/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.api;

import io.servicetalk.transport.api.BiTransportObserver;
import io.servicetalk.transport.api.CatchAllTransportObserver;
import io.servicetalk.transport.api.TransportObserver;
import java.util.Objects;

public final class TransportObservers {
    private TransportObservers() {
    }

    public static TransportObserver asSafeObserver(TransportObserver observer) {
        if (observer instanceof CatchAllTransportObserver) {
            return observer;
        }
        if (observer instanceof BiTransportObserver) {
            return observer;
        }
        return new CatchAllTransportObserver(observer);
    }

    public static TransportObserver combine(TransportObserver ... other) {
        switch (other.length) {
            case 0: {
                throw new IllegalArgumentException("At least one TransportObserver is required to combine");
            }
            case 1: {
                return Objects.requireNonNull(other[0]);
            }
        }
        BiTransportObserver bi = new BiTransportObserver(other[0], other[1]);
        for (int i = 2; i < other.length; ++i) {
            bi = new BiTransportObserver(bi, other[i]);
        }
        return bi;
    }
}

