/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.handler.codec.DecoderException;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.StringUtil;
import java.net.SocketAddress;
import javax.annotation.Nullable;

public abstract class ByteToMessageDecoder
extends ChannelInboundHandlerAdapter {
    private static final byte STATE_INIT = 0;
    private static final byte STATE_CALLING_CHILD_DECODE = 1;
    private static final byte STATE_HANDLER_REMOVED_PENDING = 2;
    @Nullable
    private ByteBuf cumulation;
    private final CtxWrapper ctxWrapper = new CtxWrapper();
    private boolean decodeWasNull;
    private byte decodeState = 0;
    private final ByteBufAllocator cumulationAllocator;

    protected ByteToMessageDecoder(ByteBufAllocator cumulationAllocator) {
        if (cumulationAllocator.isDirectBufferPooled()) {
            throw new IllegalArgumentException("ByteBufAllocator must be unpooled");
        }
        this.cumulationAllocator = cumulationAllocator;
        this.ensureNotSharable();
    }

    @Override
    public final void handlerRemoved(ChannelHandlerContext ctx) {
        if (this.decodeState == 1) {
            this.decodeState = (byte)2;
            return;
        }
        ByteBuf buf = this.cumulation;
        if (buf != null) {
            this.cumulation = null;
            this.cumulationReset();
            int readable = buf.readableBytes();
            if (readable > 0) {
                ByteBuf bytes = buf.readBytes(readable);
                buf.release();
                ctx.fireChannelRead(bytes);
                ctx.fireChannelReadComplete();
            } else {
                buf.release();
            }
        }
        this.handlerRemoved0(ctx);
    }

    protected void handlerRemoved0(ChannelHandlerContext ctx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        int firedChannelReadCount;
        block16: {
            if (!(msg instanceof ByteBuf)) {
                ctx.fireChannelRead(msg);
                return;
            }
            this.ctxWrapper.setDelegate(ctx);
            firedChannelReadCount = this.ctxWrapper.getFireChannelReadCount();
            try {
                ByteBuf data = (ByteBuf)msg;
                if (this.cumulation == null) {
                    this.cumulation = data;
                } else {
                    try {
                        int required = data.readableBytes();
                        if (required > this.cumulation.maxWritableBytes() || required > this.cumulation.maxFastWritableBytes() && this.cumulation.refCnt() > 1) {
                            this.cumulation = this.swapAndCopyCumulation(this.cumulation, data);
                        } else {
                            this.cumulation.writeBytes(data);
                        }
                    }
                    finally {
                        data.release();
                    }
                }
                this.callDecode(this.ctxWrapper, this.cumulation);
                if (this.cumulation == null) break block16;
            }
            catch (DecoderException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        throw new DecoderException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (this.cumulation != null && !this.cumulation.isReadable()) {
                        this.releaseCumulation();
                    }
                    this.decodeWasNull = firedChannelReadCount == this.ctxWrapper.getFireChannelReadCount();
                    this.ctxWrapper.resetFireChannelReadCount();
                    throw throwable;
                }
            }
            if (!this.cumulation.isReadable()) {
                this.releaseCumulation();
            }
        }
        this.decodeWasNull = firedChannelReadCount == this.ctxWrapper.getFireChannelReadCount();
        this.ctxWrapper.resetFireChannelReadCount();
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        if (this.decodeWasNull) {
            this.decodeWasNull = false;
            if (!ctx.channel().config().isAutoRead()) {
                ctx.read();
            }
        }
        ctx.fireChannelReadComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteBuf swapAndCopyCumulation(ByteBuf cumulation, ByteBuf in) {
        ByteBuf newCumulation;
        ByteBuf toRelease = newCumulation = this.cumulationAllocator.buffer(this.cumulationAllocator.calculateNewCapacity(cumulation.readableBytes() + in.readableBytes(), Integer.MAX_VALUE));
        try {
            newCumulation.writeBytes(cumulation);
            newCumulation.writeBytes(in);
            toRelease = cumulation;
            ByteBuf byteBuf = newCumulation;
            return byteBuf;
        }
        finally {
            toRelease.release();
        }
    }

    protected void cumulationReset() {
    }

    private void releaseCumulation() {
        if (this.cumulation != null) {
            this.cumulation.release();
            this.cumulation = null;
            this.cumulationReset();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        this.ctxWrapper.setDelegate(ctx);
        this.channelInputClosed(this.ctxWrapper, true);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof ChannelInputShutdownEvent) {
            this.ctxWrapper.setDelegate(ctx);
            this.channelInputClosed(this.ctxWrapper, false);
        }
        super.userEventTriggered(ctx, evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void channelInputClosed(CtxWrapper ctx, boolean callChannelInactive) {
        int firedChannelReadCount = this.ctxWrapper.getFireChannelReadCount();
        try {
            this.channelInputClosed(ctx);
        }
        catch (DecoderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DecoderException(e);
        }
        finally {
            try {
                this.releaseCumulation();
                if (firedChannelReadCount != this.ctxWrapper.getFireChannelReadCount()) {
                    ctx.fireChannelReadComplete();
                }
                if (callChannelInactive) {
                    ctx.fireChannelInactive();
                }
            }
            finally {
                this.ctxWrapper.resetFireChannelReadCount();
            }
        }
    }

    private void channelInputClosed(CtxWrapper ctx) throws Exception {
        if (this.cumulation != null) {
            this.callDecode(ctx, this.cumulation);
            this.decodeLast(ctx, this.cumulation);
        } else {
            this.decodeLast(ctx, Unpooled.EMPTY_BUFFER);
        }
    }

    private void callDecode(CtxWrapper ctx, ByteBuf in) {
        try {
            while (in.isReadable() && !ctx.isRemoved()) {
                int fireChannelReadCount = ctx.getFireChannelReadCount();
                int oldInputLength = in.readableBytes();
                this.decodeRemovalReentryProtection(ctx, in);
                if (ctx.isRemoved()) break;
                if (fireChannelReadCount == ctx.getFireChannelReadCount()) {
                    if (oldInputLength != in.readableBytes()) continue;
                    break;
                }
                if (oldInputLength != in.readableBytes()) continue;
                throw new DecoderException(StringUtil.simpleClassName(this.getClass()) + ".decode() did not read anything but decoded a message.");
            }
        }
        catch (DecoderException e) {
            throw e;
        }
        catch (Exception cause) {
            throw new DecoderException(cause);
        }
    }

    protected abstract void decode(ChannelHandlerContext var1, ByteBuf var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeRemovalReentryProtection(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        boolean removePending;
        this.decodeState = 1;
        try {
            this.decode(ctx, in);
            removePending = this.decodeState == 2;
        }
        catch (Throwable throwable) {
            boolean removePending2 = this.decodeState == 2;
            this.decodeState = 0;
            if (removePending2) {
                this.handlerRemoved(ctx);
            }
            throw throwable;
        }
        this.decodeState = 0;
        if (removePending) {
            this.handlerRemoved(ctx);
        }
    }

    protected void decodeLast(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        if (in.isReadable()) {
            this.decodeRemovalReentryProtection(ctx, in);
        }
    }

    private static final class CtxWrapper
    implements ChannelHandlerContext {
        @Nullable
        private ChannelHandlerContext delegate;
        private int fireChannelReadCount;

        private CtxWrapper() {
        }

        void setDelegate(ChannelHandlerContext delegate) {
            this.delegate = delegate;
        }

        int getFireChannelReadCount() {
            return this.fireChannelReadCount;
        }

        void resetFireChannelReadCount() {
            this.fireChannelReadCount = 0;
        }

        @Override
        public Channel channel() {
            assert (this.delegate != null);
            return this.delegate.channel();
        }

        @Override
        public EventExecutor executor() {
            assert (this.delegate != null);
            return this.delegate.executor();
        }

        @Override
        public String name() {
            assert (this.delegate != null);
            return this.delegate.name();
        }

        @Override
        public ChannelHandler handler() {
            assert (this.delegate != null);
            return this.delegate.handler();
        }

        @Override
        public boolean isRemoved() {
            assert (this.delegate != null);
            return this.delegate.isRemoved();
        }

        @Override
        public ChannelHandlerContext fireChannelRegistered() {
            assert (this.delegate != null);
            this.delegate.fireChannelRegistered();
            return this;
        }

        @Override
        public ChannelHandlerContext fireChannelUnregistered() {
            assert (this.delegate != null);
            this.delegate.fireChannelUnregistered();
            return this;
        }

        @Override
        public ChannelHandlerContext fireChannelActive() {
            assert (this.delegate != null);
            this.delegate.fireChannelActive();
            return this;
        }

        @Override
        public ChannelHandlerContext fireChannelInactive() {
            assert (this.delegate != null);
            this.delegate.fireChannelInactive();
            return this;
        }

        @Override
        public ChannelHandlerContext fireExceptionCaught(Throwable cause) {
            assert (this.delegate != null);
            this.delegate.fireExceptionCaught(cause);
            return this;
        }

        @Override
        public ChannelHandlerContext fireUserEventTriggered(Object evt) {
            assert (this.delegate != null);
            this.delegate.fireUserEventTriggered(evt);
            return this;
        }

        @Override
        public ChannelHandlerContext fireChannelRead(Object msg) {
            assert (this.delegate != null);
            ++this.fireChannelReadCount;
            this.delegate.fireChannelRead(msg);
            return this;
        }

        @Override
        public ChannelHandlerContext fireChannelReadComplete() {
            assert (this.delegate != null);
            this.delegate.fireChannelReadComplete();
            return this;
        }

        @Override
        public ChannelHandlerContext fireChannelWritabilityChanged() {
            assert (this.delegate != null);
            this.delegate.fireChannelWritabilityChanged();
            return this;
        }

        @Override
        public ChannelFuture bind(SocketAddress localAddress) {
            assert (this.delegate != null);
            return this.delegate.bind(localAddress);
        }

        @Override
        public ChannelFuture connect(SocketAddress remoteAddress) {
            assert (this.delegate != null);
            return this.delegate.connect(remoteAddress);
        }

        @Override
        public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
            assert (this.delegate != null);
            return this.delegate.connect(remoteAddress, localAddress);
        }

        @Override
        public ChannelFuture disconnect() {
            assert (this.delegate != null);
            return this.delegate.disconnect();
        }

        @Override
        public ChannelFuture close() {
            assert (this.delegate != null);
            return this.delegate.close();
        }

        @Override
        public ChannelFuture deregister() {
            assert (this.delegate != null);
            return this.delegate.deregister();
        }

        @Override
        public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
            assert (this.delegate != null);
            return this.delegate.bind(localAddress, promise);
        }

        @Override
        public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
            assert (this.delegate != null);
            return this.delegate.connect(remoteAddress, promise);
        }

        @Override
        public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            assert (this.delegate != null);
            return this.delegate.connect(remoteAddress, localAddress, promise);
        }

        @Override
        public ChannelFuture disconnect(ChannelPromise promise) {
            assert (this.delegate != null);
            return this.delegate.disconnect(promise);
        }

        @Override
        public ChannelFuture close(ChannelPromise promise) {
            assert (this.delegate != null);
            return this.delegate.close(promise);
        }

        @Override
        public ChannelFuture deregister(ChannelPromise promise) {
            assert (this.delegate != null);
            return this.delegate.deregister(promise);
        }

        @Override
        public ChannelHandlerContext read() {
            assert (this.delegate != null);
            this.delegate.read();
            return this;
        }

        @Override
        public ChannelFuture write(Object msg) {
            assert (this.delegate != null);
            return this.delegate.write(msg);
        }

        @Override
        public ChannelFuture write(Object msg, ChannelPromise promise) {
            assert (this.delegate != null);
            return this.delegate.write(msg, promise);
        }

        @Override
        public ChannelHandlerContext flush() {
            assert (this.delegate != null);
            this.delegate.flush();
            return this;
        }

        @Override
        public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
            assert (this.delegate != null);
            return this.delegate.writeAndFlush(msg, promise);
        }

        @Override
        public ChannelFuture writeAndFlush(Object msg) {
            assert (this.delegate != null);
            return this.delegate.writeAndFlush(msg);
        }

        @Override
        public ChannelPromise newPromise() {
            assert (this.delegate != null);
            return this.delegate.newPromise();
        }

        @Override
        public ChannelProgressivePromise newProgressivePromise() {
            assert (this.delegate != null);
            return this.delegate.newProgressivePromise();
        }

        @Override
        public ChannelFuture newSucceededFuture() {
            assert (this.delegate != null);
            return this.delegate.newSucceededFuture();
        }

        @Override
        public ChannelFuture newFailedFuture(Throwable cause) {
            assert (this.delegate != null);
            return this.delegate.newFailedFuture(cause);
        }

        @Override
        public ChannelPromise voidPromise() {
            assert (this.delegate != null);
            return this.delegate.voidPromise();
        }

        @Override
        public ChannelPipeline pipeline() {
            assert (this.delegate != null);
            return this.delegate.pipeline();
        }

        @Override
        public ByteBufAllocator alloc() {
            assert (this.delegate != null);
            return this.delegate.alloc();
        }

        @Override
        public <T> Attribute<T> attr(AttributeKey<T> key) {
            assert (this.delegate != null);
            return this.delegate.attr(key);
        }

        @Override
        public <T> boolean hasAttr(AttributeKey<T> key) {
            assert (this.delegate != null);
            return this.delegate.hasAttr(key);
        }
    }
}

