/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.servicetalk.transport.netty.internal.NonPipelinedCloseHandler;
import io.servicetalk.transport.netty.internal.RequestResponseCloseHandler;
import java.nio.channels.ClosedChannelException;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public abstract class CloseHandler {
    public static final CloseHandler UNSUPPORTED_PROTOCOL_CLOSE_HANDLER = new UnsupportedProtocolHandler();

    public static CloseHandler forPipelinedRequestResponse(boolean client, ChannelConfig config) {
        config.setOption(ChannelOption.ALLOW_HALF_CLOSURE, Boolean.TRUE);
        config.setAutoClose(false);
        return new RequestResponseCloseHandler(client);
    }

    public static CloseHandler forNonPipelined(boolean isClient, ChannelConfig config) {
        config.setAutoClose(false);
        return new NonPipelinedCloseHandler(isClient);
    }

    public abstract void protocolPayloadBeginInbound(ChannelHandlerContext var1);

    public abstract void protocolPayloadEndInbound(ChannelHandlerContext var1);

    public abstract void protocolPayloadBeginOutbound(ChannelHandlerContext var1);

    public abstract void protocolPayloadEndOutbound(ChannelHandlerContext var1, ChannelPromise var2);

    public abstract void protocolClosingInbound(ChannelHandlerContext var1);

    public abstract void protocolClosingOutbound(ChannelHandlerContext var1);

    abstract void registerEventHandler(Channel var1, Consumer<CloseEvent> var2);

    abstract void channelClosedInbound(ChannelHandlerContext var1);

    abstract void channelClosedOutbound(ChannelHandlerContext var1);

    abstract void closeChannelInbound(Channel var1);

    abstract void closeChannelOutbound(Channel var1);

    abstract void gracefulUserClosing(Channel var1);

    public static final class DiscardFurtherInboundEvent
    extends NettyUserEvent {
        static final DiscardFurtherInboundEvent INSTANCE = new DiscardFurtherInboundEvent();

        private DiscardFurtherInboundEvent() {
        }
    }

    static final class AbortWritesEvent
    extends NettyUserEvent {
        static final AbortWritesEvent INSTANCE = new AbortWritesEvent();

        private AbortWritesEvent() {
        }
    }

    static final class OutboundDataEndEvent
    extends NettyUserEvent {
        static final OutboundDataEndEvent INSTANCE = new OutboundDataEndEvent();

        private OutboundDataEndEvent() {
        }
    }

    private static abstract class NettyUserEvent {
        private NettyUserEvent() {
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    private static final class UnsupportedProtocolHandler
    extends CloseHandler {
        private UnsupportedProtocolHandler() {
        }

        @Override
        void registerEventHandler(Channel channel, Consumer<CloseEvent> eventHandler) {
        }

        @Override
        void channelClosedInbound(ChannelHandlerContext ctx) {
        }

        @Override
        void channelClosedOutbound(ChannelHandlerContext ctx) {
        }

        @Override
        void closeChannelInbound(Channel channel) {
            channel.close();
        }

        @Override
        void closeChannelOutbound(Channel channel) {
            channel.close();
        }

        @Override
        void gracefulUserClosing(Channel channel) {
            channel.close();
        }

        @Override
        public void protocolPayloadBeginInbound(ChannelHandlerContext ctx) {
        }

        @Override
        public void protocolPayloadEndInbound(ChannelHandlerContext ctx) {
        }

        @Override
        public void protocolPayloadBeginOutbound(ChannelHandlerContext ctx) {
        }

        @Override
        public void protocolPayloadEndOutbound(ChannelHandlerContext ctx, ChannelPromise promise) {
        }

        @Override
        public void protocolClosingInbound(ChannelHandlerContext ctx) {
        }

        @Override
        public void protocolClosingOutbound(ChannelHandlerContext ctx) {
        }
    }

    public static final class CloseEventObservedException
    extends ClosedChannelException {
        private static final long serialVersionUID = -4181001701486049092L;
        private final CloseEvent event;
        private final String channelDetails;

        private CloseEventObservedException(@Nullable Throwable cause, CloseEvent closeEvent, Channel channel) {
            this.event = closeEvent;
            this.channelDetails = channel.toString();
            this.initCause(cause);
        }

        public CloseEvent event() {
            return this.event;
        }

        @Override
        public String getMessage() {
            return this.event.name() + "(" + this.event.description + ") " + this.channelDetails;
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    public static enum CloseEvent {
        PROTOCOL_CLOSING_OUTBOUND("The application protocol closed the write side of this connection. This maybe the result of sending an HTTP header such as Connection: close."),
        PROTOCOL_CLOSING_INBOUND("The application protocol closed the read side of this connection. This maybe the result of sending an HTTP header such as Connection: close."),
        GRACEFUL_USER_CLOSING("The graceful close* method was called in the local application."),
        CHANNEL_CLOSED_OUTBOUND("The transport backing this connection has been shutdown (write)"),
        CHANNEL_CLOSED_INBOUND("The transport backing this connection has been shutdown (read)");

        private final String description;

        private CloseEvent(String description) {
            this.description = description;
        }

        Throwable wrapError(@Nullable Throwable cause, Channel channel) {
            return new CloseEventObservedException(cause, this, channel);
        }
    }
}

