/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.transport.netty.internal.DelegatingFlushStrategy;
import io.servicetalk.transport.netty.internal.FlushStrategy;
import io.servicetalk.transport.netty.internal.NettyConnectionContext;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class FlushStrategyHolder {
    private static final AtomicReferenceFieldUpdater<FlushStrategyHolder, FlushStrategy> flushStrategyUpdater = AtomicReferenceFieldUpdater.newUpdater(FlushStrategyHolder.class, FlushStrategy.class, "flushStrategy");
    private final FlushStrategy originalFlushStrategy;
    private volatile FlushStrategy flushStrategy;

    public FlushStrategyHolder(FlushStrategy flushStrategy) {
        this.flushStrategy = this.originalFlushStrategy = new DelegatingFlushStrategy(flushStrategy);
    }

    public FlushStrategy currentStrategy() {
        return this.flushStrategy;
    }

    public Cancellable updateFlushStrategy(NettyConnectionContext.FlushStrategyProvider strategyProvider) {
        FlushStrategy newStrategy;
        FlushStrategy cStrategy;
        while (!flushStrategyUpdater.compareAndSet(this, cStrategy, newStrategy = strategyProvider.computeFlushStrategy(cStrategy, (cStrategy = this.flushStrategy) == this.originalFlushStrategy))) {
        }
        return () -> flushStrategyUpdater.getAndUpdate(this, fs -> fs == newStrategy ? this.originalFlushStrategy : fs);
    }
}

