/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleTimeoutInitializer
implements ChannelInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdleTimeoutInitializer.class);
    private final long timeoutMs;

    public IdleTimeoutInitializer(Duration idleTimeout) {
        this(idleTimeout.toMillis());
    }

    public IdleTimeoutInitializer(long idleTimeoutMillis) {
        this.timeoutMs = idleTimeoutMillis;
    }

    @Override
    public void init(Channel channel) {
        if (this.timeoutMs > 0L) {
            LOGGER.debug("Channel idle timeout is {}ms.", (Object)this.timeoutMs);
            channel.pipeline().addLast(new IdleStateHandler(0L, 0L, this.timeoutMs, TimeUnit.MILLISECONDS){

                @Override
                protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) {
                    if (evt.state() == IdleState.ALL_IDLE) {
                        ctx.pipeline().remove(this);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Closing channel {} after {}ms of inactivity.", (Object)ctx.channel(), (Object)IdleTimeoutInitializer.this.timeoutMs);
                        }
                        ctx.fireUserEventTriggered(evt);
                        ctx.close();
                    }
                }
            });
        }
    }
}

