/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.util.concurrent.FastThreadLocalThread;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextMapHolder;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public final class IoThreadFactory
implements ThreadFactory {
    private static final AtomicInteger factoryCount = new AtomicInteger();
    private final AtomicInteger threadCount = new AtomicInteger();
    private final String namePrefix;
    private final boolean daemon;
    private final int priority;
    private final ThreadGroup threadGroup;

    public IoThreadFactory(String threadNamePrefix) {
        this(threadNamePrefix, false);
    }

    public IoThreadFactory(String threadNamePrefix, boolean daemon) {
        this.namePrefix = Objects.requireNonNull(threadNamePrefix) + '-' + factoryCount.incrementAndGet() + '-';
        this.daemon = daemon;
        this.threadGroup = System.getSecurityManager() == null ? Thread.currentThread().getThreadGroup() : System.getSecurityManager().getThreadGroup();
        this.priority = 5;
    }

    @Override
    public Thread newThread(Runnable r) {
        AsyncContextHolderNettyThread t = new AsyncContextHolderNettyThread(this.threadGroup, r, this.namePrefix + this.threadCount.incrementAndGet());
        if (t.isDaemon() != this.daemon) {
            t.setDaemon(this.daemon);
        }
        if (t.getPriority() != this.priority) {
            t.setPriority(this.priority);
        }
        return t;
    }

    private static final class AsyncContextHolderNettyThread
    extends FastThreadLocalThread
    implements AsyncContextMapHolder {
        @Nullable
        private AsyncContextMap asyncContextMap;

        AsyncContextHolderNettyThread(ThreadGroup group, Runnable target, String name) {
            super(group, target, name);
        }

        @Override
        public void asyncContextMap(@Nullable AsyncContextMap asyncContextMap) {
            this.asyncContextMap = asyncContextMap;
        }

        @Override
        @Nullable
        public AsyncContextMap asyncContextMap() {
            return this.asyncContextMap;
        }
    }
}

