/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.util.concurrent.Future;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.internal.SubscribableCompletable;
import java.util.function.Supplier;

public final class NettyFutureCompletable
extends SubscribableCompletable {
    private final Supplier<Future<?>> futureSupplier;

    public NettyFutureCompletable(Supplier<Future<?>> futureSupplier) {
        this.futureSupplier = futureSupplier;
    }

    @Override
    protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
        Future<?> future = this.futureSupplier.get();
        subscriber.onSubscribe(() -> future.cancel(true));
        NettyFutureCompletable.connectToSubscriber(subscriber, future);
    }

    static void connectToSubscriber(CompletableSource.Subscriber subscriber, Future<?> future) {
        future.addListener(f -> {
            Throwable cause = f.cause();
            if (cause == null) {
                subscriber.onComplete();
            } else {
                subscriber.onError(cause);
            }
        });
    }
}

