/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.servicetalk.transport.netty.internal.CloseHandler;
import io.servicetalk.transport.netty.internal.RequestResponseCloseHandler;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;

final class NonPipelinedCloseHandler
extends CloseHandler {
    private static final byte READ = 1;
    private static final byte WRITE = 2;
    private static final byte IN_CLOSED = 4;
    private static final byte OUT_CLOSED = 8;
    private static final byte CLOSED = 16;
    private static final byte GRACEFUL_CLOSE = 32;
    private static final byte IS_CLIENT = 64;
    private static final byte ALL_CLOSED = 28;
    private static final byte READ_WRITE = 3;
    private static final byte CLIENT_IN_WRITE = 70;
    private static final byte GRACEFUL_IN_CLOSED = 36;
    private static final byte GRACEFUL_OUT_CLOSED = 40;
    private byte state;
    private Consumer<CloseHandler.CloseEvent> eventHandler = __ -> {};
    @Nullable
    private CloseHandler.CloseEvent closeEvent;

    NonPipelinedCloseHandler(boolean isClient) {
        if (isClient) {
            this.state = (byte)64;
        }
    }

    @Override
    public void protocolPayloadBeginInbound(ChannelHandlerContext ctx) {
        this.state = NonPipelinedCloseHandler.set(this.state, (byte)1);
    }

    @Override
    public void protocolPayloadEndInbound(ChannelHandlerContext ctx) {
        this.state = NonPipelinedCloseHandler.unset(this.state, (byte)1);
        this.inboundEventCheckClose(ctx.channel());
    }

    @Override
    public void protocolPayloadBeginOutbound(ChannelHandlerContext ctx) {
        this.state = NonPipelinedCloseHandler.set(this.state, (byte)2);
    }

    @Override
    public void protocolPayloadEndOutbound(ChannelHandlerContext ctx, ChannelPromise promise) {
        ctx.pipeline().fireUserEventTriggered(CloseHandler.OutboundDataEndEvent.INSTANCE);
        promise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            this.state = NonPipelinedCloseHandler.unset(this.state, (byte)2);
            this.outboundEventCheckClose(ctx.channel());
        }));
    }

    @Override
    public void protocolClosingInbound(ChannelHandlerContext ctx) {
        this.state = NonPipelinedCloseHandler.set(this.state, (byte)4);
        this.storeCloseRequestAndEmit(CloseHandler.CloseEvent.PROTOCOL_CLOSING_INBOUND);
        this.inboundEventCheckClose(ctx.channel());
    }

    @Override
    public void protocolClosingOutbound(ChannelHandlerContext ctx) {
        this.state = NonPipelinedCloseHandler.set(this.state, (byte)8);
        this.storeCloseRequestAndEmit(CloseHandler.CloseEvent.PROTOCOL_CLOSING_OUTBOUND);
        this.outboundEventCheckClose(ctx.channel());
    }

    @Override
    void registerEventHandler(Channel channel, Consumer<CloseHandler.CloseEvent> eventHandler) {
        this.eventHandler = Objects.requireNonNull(eventHandler);
    }

    @Override
    void channelClosedInbound(ChannelHandlerContext ctx) {
        this.state = NonPipelinedCloseHandler.unset(NonPipelinedCloseHandler.set(this.state, (byte)4), (byte)1);
        this.storeCloseRequestAndEmit(CloseHandler.CloseEvent.CHANNEL_CLOSED_INBOUND);
        this.inboundEventCheckClose(ctx.channel());
    }

    @Override
    void channelClosedOutbound(ChannelHandlerContext ctx) {
        this.state = NonPipelinedCloseHandler.unset(NonPipelinedCloseHandler.set(this.state, (byte)8), (byte)2);
        this.storeCloseRequestAndEmit(CloseHandler.CloseEvent.CHANNEL_CLOSED_OUTBOUND);
        this.outboundEventCheckClose(ctx.channel());
    }

    @Override
    void closeChannelInbound(Channel channel) {
        this.state = NonPipelinedCloseHandler.set(this.state, (byte)4);
        this.inboundEventCheckClose(channel);
    }

    @Override
    void closeChannelOutbound(Channel channel) {
        this.state = NonPipelinedCloseHandler.set(this.state, (byte)8);
        this.outboundEventCheckClose(channel);
    }

    @Override
    void gracefulUserClosing(Channel channel) {
        this.state = NonPipelinedCloseHandler.set(this.state, (byte)32);
        this.storeCloseRequestAndEmit(CloseHandler.CloseEvent.GRACEFUL_USER_CLOSING);
        if (!NonPipelinedCloseHandler.isAnySet(this.state, (byte)3)) {
            this.closeChannel(channel);
        }
    }

    private void inboundEventCheckClose(Channel channel) {
        if (NonPipelinedCloseHandler.isAllSet(this.state, (byte)8) || NonPipelinedCloseHandler.isAnySet(this.state, (byte)36) && !NonPipelinedCloseHandler.isAllSet(this.state, (byte)2)) {
            this.closeChannel(channel);
        } else if (NonPipelinedCloseHandler.isAllSet(this.state, (byte)70)) {
            this.state = NonPipelinedCloseHandler.unset(this.state, (byte)2);
            channel.pipeline().fireUserEventTriggered(CloseHandler.AbortWritesEvent.INSTANCE);
        }
    }

    private void outboundEventCheckClose(Channel channel) {
        if (NonPipelinedCloseHandler.isAllSet(this.state, (byte)4) || NonPipelinedCloseHandler.isAnySet(this.state, (byte)40) && !NonPipelinedCloseHandler.isAllSet(this.state, (byte)1)) {
            this.closeChannel(channel);
        }
    }

    private void storeCloseRequestAndEmit(CloseHandler.CloseEvent event) {
        if (this.closeEvent == null) {
            this.closeEvent = event;
        }
        this.eventHandler.accept(event);
    }

    private void closeChannel(Channel channel) {
        if (!RequestResponseCloseHandler.State.has(this.state, (byte)16)) {
            this.state = NonPipelinedCloseHandler.set(this.state, (byte)28);
            channel.close();
        }
    }

    private static byte set(byte state, byte flags) {
        return (byte)(state | flags);
    }

    private static byte unset(byte state, byte flags) {
        return (byte)(state & ~flags);
    }

    private static boolean isAllSet(byte state, byte flags) {
        return (state & flags) == flags;
    }

    private static boolean isAnySet(byte state, byte flags) {
        return (state & flags) != 0;
    }
}

