/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.internal.StringUtil;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferHolder;
import io.servicetalk.buffer.netty.BufferUtils;
import io.servicetalk.logging.slf4j.internal.FixedLevelLogger;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;

@ChannelHandler.Sharable
final class ServiceTalkWireLogger
extends ChannelDuplexHandler {
    private final FixedLevelLogger logger;
    private final BooleanSupplier logUserDataSupplier;

    ServiceTalkWireLogger(FixedLevelLogger logger, BooleanSupplier logUserDataSupplier) {
        this.logger = Objects.requireNonNull(logger);
        this.logUserDataSupplier = Objects.requireNonNull(logUserDataSupplier);
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) {
        if (this.logger.isEnabled()) {
            this.logger.log(ServiceTalkWireLogger.contextToString(ctx) + " REGISTERED");
        }
        ctx.fireChannelRegistered();
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) {
        if (this.logger.isEnabled()) {
            this.logger.log(ServiceTalkWireLogger.contextToString(ctx) + " UNREGISTERED");
        }
        ctx.fireChannelUnregistered();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        if (this.logger.isEnabled()) {
            this.logger.log(ServiceTalkWireLogger.contextToString(ctx) + " ACTIVE");
        }
        ctx.fireChannelActive();
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.logger.isEnabled()) {
            this.logger.log(ServiceTalkWireLogger.contextToString(ctx) + " INACTIVE");
        }
        ctx.fireChannelInactive();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.logger.isEnabled()) {
            this.logger.log(ServiceTalkWireLogger.formatSimple(ctx, "EXCEPTION", cause));
        }
        ctx.fireExceptionCaught(cause);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (this.logger.isEnabled()) {
            this.logger.log(this.format(ctx, "USER_EVENT", evt));
        }
        ctx.fireUserEventTriggered(evt);
    }

    @Override
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) {
        if (this.logger.isEnabled()) {
            this.logger.log(ServiceTalkWireLogger.formatSimple(ctx, "BIND", localAddress));
        }
        ctx.bind(localAddress, promise);
    }

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        if (this.logger.isEnabled()) {
            this.logger.log(ServiceTalkWireLogger.contextToString(ctx) + " CONNECT: " + (localAddress == null ? remoteAddress : localAddress + " -> " + remoteAddress));
        }
        ctx.connect(remoteAddress, localAddress, promise);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) {
        if (this.logger.isEnabled()) {
            this.logger.log(ServiceTalkWireLogger.contextToString(ctx) + " DISCONNECT");
        }
        ctx.disconnect(promise);
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
        if (this.logger.isEnabled()) {
            this.logger.log(ServiceTalkWireLogger.contextToString(ctx) + " CLOSE");
        }
        ctx.close(promise);
    }

    @Override
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) {
        if (this.logger.isEnabled()) {
            this.logger.log(ServiceTalkWireLogger.contextToString(ctx) + " DEREGISTER");
        }
        ctx.deregister(promise);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        if (this.logger.isEnabled()) {
            this.logger.log(ServiceTalkWireLogger.contextToString(ctx) + " READ_COMPLETE");
        }
        ctx.fireChannelReadComplete();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.logger.isEnabled()) {
            this.logger.log(this.format(ctx, "READ", msg));
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void read(ChannelHandlerContext ctx) {
        if (this.logger.isEnabled()) {
            this.logger.log(ServiceTalkWireLogger.contextToString(ctx) + " READ_REQUEST");
        }
        ctx.read();
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (this.logger.isEnabled()) {
            this.logger.log(this.format(ctx, "WRITE", msg));
        }
        ctx.write(msg, promise);
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        if (this.logger.isEnabled()) {
            boolean curr = ctx.channel().isWritable();
            boolean prev = !curr;
            this.logger.log(ServiceTalkWireLogger.contextToString(ctx) + " WRITABILITY_CHANGED: " + prev + " -> " + curr);
        }
        ctx.fireChannelWritabilityChanged();
    }

    @Override
    public void flush(ChannelHandlerContext ctx) {
        if (this.logger.isEnabled()) {
            this.logger.log(ServiceTalkWireLogger.contextToString(ctx) + " FLUSH");
        }
        ctx.flush();
    }

    private static String formatByteBuf(ChannelHandlerContext ctx, String eventName, ByteBuf msg) {
        return ServiceTalkWireLogger.formatByteBuf(ctx, eventName, null, msg);
    }

    private static String formatByteBufNoData(ChannelHandlerContext ctx, String eventName, ByteBuf msg) {
        return ServiceTalkWireLogger.contextToString(ctx) + ' ' + eventName + ": " + msg.readableBytes() + 'B';
    }

    private static <T> String formatByteBufHolder(ChannelHandlerContext ctx, String eventName, T msg, Function<T, ByteBuf> byteBufExtractor) {
        return ServiceTalkWireLogger.formatByteBuf(ctx, eventName, ServiceTalkWireLogger.msgToString(msg), byteBufExtractor.apply(msg));
    }

    private static String formatByteBufHolderNoData(ChannelHandlerContext ctx, String eventName, Object msg, IntSupplier readableBytes) {
        return ServiceTalkWireLogger.contextToString(ctx) + ' ' + eventName + ": " + ServiceTalkWireLogger.msgToString(msg) + ' ' + readableBytes.getAsInt() + 'B';
    }

    private static String formatByteBuf(ChannelHandlerContext ctx, String eventName, @Nullable String prefix, ByteBuf msg) {
        String channelString = ServiceTalkWireLogger.contextToString(ctx);
        int length = msg.readableBytes();
        int outputLength = channelString.length() + 1 + eventName.length() + 2 + (prefix != null ? prefix.length() + 1 : 0) + 10 + 1;
        if (length > 0) {
            int rows = length / 16 + (length % 15 == 0 ? 0 : 1) + 4;
            int hexDumpLength = 2 + rows * 80;
            outputLength += hexDumpLength;
        }
        StringBuilder buf = new StringBuilder(outputLength).append(channelString).append(' ').append(eventName).append(": ");
        if (prefix != null) {
            buf.append(prefix).append(' ');
        }
        buf.append(length).append('B');
        if (length > 0) {
            buf.append(StringUtil.NEWLINE);
            ByteBufUtil.appendPrettyHexDump(buf, msg);
        }
        return buf.toString();
    }

    private String format(ChannelHandlerContext ctx, String eventName, Object msg) {
        boolean logUserData = this.logUserDataSupplier.getAsBoolean();
        if (msg instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)msg;
            return logUserData ? ServiceTalkWireLogger.formatByteBuf(ctx, eventName, byteBuf) : ServiceTalkWireLogger.formatByteBufNoData(ctx, eventName, byteBuf);
        }
        if (msg instanceof ByteBufHolder) {
            ByteBufHolder holder = (ByteBufHolder)msg;
            return logUserData ? ServiceTalkWireLogger.formatByteBufHolder(ctx, eventName, holder, ByteBufHolder::content) : ServiceTalkWireLogger.formatByteBufHolderNoData(ctx, eventName, holder, holder.content()::readableBytes);
        }
        if (msg instanceof Buffer) {
            ByteBuf byteBuf = BufferUtils.toByteBuf((Buffer)msg);
            return logUserData ? ServiceTalkWireLogger.formatByteBuf(ctx, eventName, byteBuf) : ServiceTalkWireLogger.formatByteBufNoData(ctx, eventName, byteBuf);
        }
        if (msg instanceof BufferHolder) {
            BufferHolder holder = (BufferHolder)msg;
            return logUserData ? ServiceTalkWireLogger.formatByteBufHolder(ctx, eventName, holder, h -> BufferUtils.toByteBuf(h.content())) : ServiceTalkWireLogger.formatByteBufHolderNoData(ctx, eventName, holder, holder.content()::readableBytes);
        }
        return ServiceTalkWireLogger.contextToString(ctx) + ' ' + eventName + ": " + (logUserData ? String.valueOf(msg) : ServiceTalkWireLogger.msgToString(msg));
    }

    private static String formatSimple(ChannelHandlerContext ctx, String eventName, Object msg) {
        return ServiceTalkWireLogger.contextToString(ctx) + ' ' + eventName + ": " + msg;
    }

    private static String contextToString(ChannelHandlerContext ctx) {
        return ctx.channel().toString();
    }

    private static String msgToString(Object msg) {
        return msg.getClass().toString();
    }
}

