/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.servicetalk.transport.netty.internal.BuilderUtils;
import io.servicetalk.transport.netty.internal.ReadOnlyClientSecurityConfig;
import io.servicetalk.transport.netty.internal.ReadOnlySecurityConfig;
import io.servicetalk.transport.netty.internal.ReadOnlyServerSecurityConfig;
import io.servicetalk.transport.netty.internal.SslUtils;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;

public final class SslContextFactory {
    private SslContextFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SslContext forClient(ReadOnlyClientSecurityConfig config, List<String> supportedAlpnProtocols) {
        Objects.requireNonNull(config);
        SslContextBuilder builder = SslContextBuilder.forClient().sessionCacheSize(config.sessionCacheSize()).sessionTimeout(config.sessionTimeout());
        SslContextFactory.configureTrustManager(config, builder);
        KeyManagerFactory keyManagerFactory = config.keyManagerFactory();
        if (keyManagerFactory != null) {
            builder.keyManager(keyManagerFactory);
        } else {
            InputStream keyCertChainSupplier = null;
            InputStream keySupplier = null;
            try {
                keyCertChainSupplier = config.keyCertChainSupplier().get();
                keySupplier = config.keySupplier().get();
                builder.keyManager(keyCertChainSupplier, keySupplier, config.keyPassword());
            }
            catch (Throwable throwable) {
                try {
                    BuilderUtils.closeAndRethrowUnchecked(keyCertChainSupplier);
                    throw throwable;
                }
                finally {
                    BuilderUtils.closeAndRethrowUnchecked(keySupplier);
                }
            }
            try {
                BuilderUtils.closeAndRethrowUnchecked(keyCertChainSupplier);
            }
            finally {
                BuilderUtils.closeAndRethrowUnchecked(keySupplier);
            }
        }
        builder.sslProvider(SslUtils.toNettySslProvider(config.provider(), !supportedAlpnProtocols.isEmpty()));
        builder.protocols(config.protocols());
        builder.ciphers(config.ciphers());
        builder.applicationProtocolConfig(SslUtils.nettyApplicationProtocol(supportedAlpnProtocols));
        try {
            return builder.build();
        }
        catch (SSLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SslContext forServer(ReadOnlyServerSecurityConfig config, List<String> supportedAlpnProtocols) {
        SslContextBuilder builder;
        Objects.requireNonNull(config);
        KeyManagerFactory keyManagerFactory = config.keyManagerFactory();
        if (keyManagerFactory != null) {
            builder = SslContextBuilder.forServer(keyManagerFactory);
        } else {
            InputStream keyCertChainSupplier = null;
            InputStream keySupplier = null;
            try {
                keyCertChainSupplier = config.keyCertChainSupplier().get();
                keySupplier = config.keySupplier().get();
                builder = SslContextBuilder.forServer(keyCertChainSupplier, keySupplier, config.keyPassword());
            }
            catch (Throwable throwable) {
                try {
                    BuilderUtils.closeAndRethrowUnchecked(keyCertChainSupplier);
                    throw throwable;
                }
                finally {
                    BuilderUtils.closeAndRethrowUnchecked(keySupplier);
                }
            }
            try {
                BuilderUtils.closeAndRethrowUnchecked(keyCertChainSupplier);
            }
            finally {
                BuilderUtils.closeAndRethrowUnchecked(keySupplier);
            }
        }
        builder.sessionCacheSize(config.sessionCacheSize()).sessionTimeout(config.sessionTimeout()).applicationProtocolConfig(SslUtils.nettyApplicationProtocol(supportedAlpnProtocols));
        switch (config.clientAuth()) {
            case NONE: {
                builder.clientAuth(ClientAuth.NONE);
                break;
            }
            case OPTIONAL: {
                builder.clientAuth(ClientAuth.OPTIONAL);
                break;
            }
            case REQUIRE: {
                builder.clientAuth(ClientAuth.REQUIRE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported ClientAuth value: " + (Object)((Object)config.clientAuth()));
            }
        }
        SslContextFactory.configureTrustManager(config, builder);
        builder.protocols(config.protocols());
        builder.ciphers(config.ciphers());
        builder.sslProvider(SslUtils.toNettySslProvider(config.provider(), !supportedAlpnProtocols.isEmpty()));
        try {
            return builder.build();
        }
        catch (SSLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static void configureTrustManager(ReadOnlySecurityConfig config, SslContextBuilder builder) {
        if (config.trustManagerFactory() != null) {
            builder.trustManager(config.trustManagerFactory());
        } else {
            InputStream trustManagerStream = config.trustCertChainSupplier().get();
            try {
                builder.trustManager(trustManagerStream);
            }
            finally {
                BuilderUtils.closeAndRethrowUnchecked(trustManagerStream);
            }
        }
    }
}

