/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.utils.internal;

import io.servicetalk.utils.internal.ReflectionUtils;
import java.io.FileDescriptor;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

final class PlatformDependent0 {
    private static final Logger LOGGER;
    private static final boolean IS_EXPLICIT_NO_UNSAFE;
    private static final String DEALLOCATOR_CLASS_NAME = "java.nio.DirectByteBuffer$Deallocator";
    @Nullable
    private static final Unsafe UNSAFE;
    @Nullable
    private static final MethodHandle DIRECT_BUFFER_CONSTRUCTOR;
    @Nullable
    private static final MethodHandle DEALLOCATOR_CONSTRUCTOR;
    @Nullable
    private static final MethodHandle RESERVE_MEMORY;
    @Nullable
    private static final MethodHandle UNRESERVE_MEMORY;
    private static final boolean USE_DIRECT_BUFFER_WITHOUT_ZEROING;

    private PlatformDependent0() {
    }

    static boolean hasUnsafe() {
        return UNSAFE != null;
    }

    static boolean useDirectBufferWithoutZeroing() {
        return USE_DIRECT_BUFFER_WITHOUT_ZEROING;
    }

    static void reserveMemory(long size, int capacity) {
        assert (RESERVE_MEMORY != null);
        try {
            RESERVE_MEMORY.invoke(size, capacity);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    static void unreserveMemory(long size, int capacity) {
        assert (UNRESERVE_MEMORY != null);
        try {
            UNRESERVE_MEMORY.invoke(size, capacity);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    static long allocateMemory(long size) {
        assert (UNSAFE != null);
        return UNSAFE.allocateMemory(size);
    }

    static void freeMemory(long address) {
        assert (UNSAFE != null);
        UNSAFE.freeMemory(address);
    }

    static ByteBuffer newDirectBuffer(long address, long size, int capacity) {
        assert (DEALLOCATOR_CONSTRUCTOR != null);
        assert (DIRECT_BUFFER_CONSTRUCTOR != null);
        try {
            Runnable deallocator = DEALLOCATOR_CONSTRUCTOR.invoke(address, size, capacity);
            return DIRECT_BUFFER_CONSTRUCTOR.invoke(capacity, address, null, deallocator);
        }
        catch (Throwable cause) {
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new Error(cause);
        }
    }

    static void throwException(Throwable cause) {
        assert (UNSAFE != null);
        UNSAFE.throwException(Objects.requireNonNull(cause));
    }

    static {
        MethodHandles.Lookup lookup;
        ByteBuffer direct;
        Unsafe unsafe;
        LOGGER = LoggerFactory.getLogger(PlatformDependent0.class);
        IS_EXPLICIT_NO_UNSAFE = Boolean.getBoolean("io.servicetalk.noUnsafe");
        if (IS_EXPLICIT_NO_UNSAFE) {
            unsafe = null;
        } else {
            Object maybeUnsafe = AccessController.doPrivileged(() -> {
                try {
                    Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
                    Throwable cause = ReflectionUtils.trySetAccessible(unsafeField, false);
                    if (cause != null) {
                        return cause;
                    }
                    return unsafeField.get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
                    return e;
                }
            });
            if (maybeUnsafe instanceof Exception) {
                unsafe = null;
                LOGGER.debug("sun.misc.Unsafe.theUnsafe: unavailable", (Exception)maybeUnsafe);
            } else {
                unsafe = (Unsafe)maybeUnsafe;
                LOGGER.debug("sun.misc.Unsafe.theUnsafe: available");
            }
        }
        UNSAFE = unsafe;
        if (UNSAFE == null) {
            direct = null;
            lookup = null;
            DIRECT_BUFFER_CONSTRUCTOR = null;
        } else {
            direct = ByteBuffer.allocateDirect(1);
            lookup = MethodHandles.lookup();
            DIRECT_BUFFER_CONSTRUCTOR = ReflectionUtils.lookupAccessibleObject(() -> direct.getClass().getDeclaredConstructor(Integer.TYPE, Long.TYPE, FileDescriptor.class, Runnable.class), Constructor.class, constructor -> {
                long address = 0L;
                try {
                    MethodHandle methodHandle = lookup.unreflectConstructor((Constructor<?>)constructor);
                    address = PlatformDependent0.allocateMemory(1L);
                    if (methodHandle.invoke(1, address, null, () -> {}) instanceof ByteBuffer) {
                        MethodHandle methodHandle2 = methodHandle;
                        return methodHandle2;
                    }
                    MethodHandle methodHandle3 = null;
                    return methodHandle3;
                }
                finally {
                    if (address != 0L) {
                        PlatformDependent0.freeMemory(address);
                    }
                }
            });
        }
        LOGGER.debug("java.nio.DirectByteBuffer.<init>(int, long, FileDescriptor, Runnable): {}", (Object)(DIRECT_BUFFER_CONSTRUCTOR != null ? "available" : "unavailable"));
        DEALLOCATOR_CONSTRUCTOR = UNSAFE == null || DIRECT_BUFFER_CONSTRUCTOR == null ? null : ReflectionUtils.lookupAccessibleObject(() -> {
            for (Class<?> innerClass : direct.getClass().getDeclaredClasses()) {
                if (!DEALLOCATOR_CLASS_NAME.equals(innerClass.getName())) continue;
                return innerClass.getDeclaredConstructor(Long.TYPE, Long.TYPE, Integer.TYPE);
            }
            return null;
        }, Constructor.class, constructor -> {
            MethodHandle methodHandle = lookup.unreflectConstructor((Constructor<?>)constructor);
            if (methodHandle.invoke(0L, 0L, 0) instanceof Runnable) {
                return methodHandle;
            }
            return null;
        });
        LOGGER.debug("java.nio.DirectByteBuffer$Deallocator.<init>(long, long, int): {}", (Object)(DIRECT_BUFFER_CONSTRUCTOR != null ? "available" : "unavailable"));
        if (UNSAFE == null || DIRECT_BUFFER_CONSTRUCTOR == null || DEALLOCATOR_CONSTRUCTOR == null) {
            RESERVE_MEMORY = null;
            UNRESERVE_MEMORY = null;
        } else {
            RESERVE_MEMORY = ReflectionUtils.extractNioBitsMethod("reserveMemory", lookup);
            UNRESERVE_MEMORY = ReflectionUtils.extractNioBitsMethod("unreserveMemory", lookup);
        }
        LOGGER.debug("java.nio.Bits.reserveMemory(long, int): {}", (Object)(RESERVE_MEMORY != null ? "available" : "unavailable"));
        LOGGER.debug("java.nio.Bits.unreserveMemory(long, int): {}", (Object)(UNRESERVE_MEMORY != null ? "available" : "unavailable"));
        USE_DIRECT_BUFFER_WITHOUT_ZEROING = UNSAFE != null && DIRECT_BUFFER_CONSTRUCTOR != null && DEALLOCATOR_CONSTRUCTOR != null && RESERVE_MEMORY != null && UNRESERVE_MEMORY != null;
        LOGGER.debug("Allocation of DirectByteBuffer without zeroing memory: {}", (Object)(USE_DIRECT_BUFFER_WITHOUT_ZEROING ? "available" : "unavailable"));
    }
}

