/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.buffer.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.ByteProcessor;
import io.servicetalk.buffer.api.IndexOfByteProcessor;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

abstract class AbstractBuffer
implements Buffer {
    private int readerIndex;
    private int writerIndex;

    AbstractBuffer(int readerIndex, int writerIndex) {
        this.readerIndex = readerIndex;
        this.writerIndex = writerIndex;
    }

    @Override
    public final int readerIndex() {
        return this.readerIndex;
    }

    @Override
    public final Buffer readerIndex(int readerIndex) {
        if (readerIndex < 0 || readerIndex > this.writerIndex) {
            throw new IndexOutOfBoundsException("readerIndex must be in the range[0," + this.writerIndex + ") but was: " + readerIndex);
        }
        this.readerIndex = readerIndex;
        return this;
    }

    @Override
    public final int writerIndex() {
        return this.writerIndex;
    }

    @Override
    public final Buffer writerIndex(int writerIndex) {
        if (writerIndex < this.readerIndex || writerIndex > this.capacity()) {
            throw new IndexOutOfBoundsException("writerIndex must be in the range[" + this.readerIndex + "," + this.capacity() + "] but was: " + writerIndex);
        }
        this.writerIndex = writerIndex;
        return this;
    }

    @Override
    public final int readableBytes() {
        return this.writerIndex - this.readerIndex;
    }

    @Override
    public final Buffer clear() {
        this.readerIndex = 0;
        this.writerIndex = 0;
        return this;
    }

    @Override
    public final byte getByte(int index) {
        this.checkIndex0(index, 1);
        return this.getByteNoBounds(index);
    }

    protected abstract byte getByteNoBounds(int var1);

    @Override
    public final boolean getBoolean(int index) {
        return this.getByte(index) != 0;
    }

    @Override
    public final short getShort(int index) {
        this.checkIndex0(index, 2);
        return this.getShortNoBounds(index);
    }

    protected abstract short getShortNoBounds(int var1);

    @Override
    public final char getChar(int index) {
        return (char)this.getShort(index);
    }

    @Override
    public final short getUnsignedByte(int index) {
        return (short)(this.getByte(index) & 0xFF);
    }

    @Override
    public final short getShortLE(int index) {
        this.checkIndex0(index, 2);
        return this.getShortLENoBounds(index);
    }

    protected short getShortLENoBounds(int index) {
        return Short.reverseBytes(this.getShortNoBounds(index));
    }

    @Override
    public final int getUnsignedShort(int index) {
        return this.getShort(index) & 0xFFF;
    }

    @Override
    public final int getUnsignedShortLE(int index) {
        return this.getShortLE(index) & 0xFFFF;
    }

    @Override
    public final int getUnsignedMedium(int index) {
        this.checkIndex0(index, 3);
        return this.getUnsignedMediumNoBounds(index);
    }

    protected int getUnsignedMediumNoBounds(int index) {
        return (this.getByteNoBounds(index) & 0xFF) << 16 | (this.getByteNoBounds(index + 1) & 0xFF) << 8 | this.getByteNoBounds(index + 2) & 0xFF;
    }

    @Override
    public int getUnsignedMediumLE(int index) {
        this.checkIndex0(index, 3);
        return this.getUnsignedMediumLENoBounds(index);
    }

    protected int getUnsignedMediumLENoBounds(int index) {
        return this.getByteNoBounds(index) & 0xFF | (this.getByteNoBounds(index + 1) & 0xFF) << 8 | (this.getByteNoBounds(index + 2) & 0xFF) << 16;
    }

    @Override
    public final int getMedium(int index) {
        int value = this.getUnsignedMedium(index);
        if ((value & 0x800000) != 0) {
            value |= 0xFF000000;
        }
        return value;
    }

    @Override
    public final int getMediumLE(int index) {
        int value = this.getUnsignedMediumLE(index);
        if ((value & 0x800000) != 0) {
            value |= 0xFF000000;
        }
        return value;
    }

    @Override
    public final int getInt(int index) {
        this.checkIndex0(index, 4);
        return this.getIntNoBounds(index);
    }

    protected abstract int getIntNoBounds(int var1);

    @Override
    public final int getIntLE(int index) {
        this.checkIndex0(index, 4);
        return this.getIntLENoBounds(index);
    }

    protected final int getIntLENoBounds(int index) {
        return Integer.reverseBytes(this.getIntNoBounds(index));
    }

    @Override
    public final long getUnsignedInt(int index) {
        return (long)this.getInt(index) & 0xFFFFFFFFL;
    }

    @Override
    public final long getUnsignedIntLE(int index) {
        return (long)this.getIntLE(index) & 0xFFFFFFFFL;
    }

    @Override
    public final long getLong(int index) {
        this.checkIndex0(index, 8);
        return this.getLongNoBounds(index);
    }

    protected abstract long getLongNoBounds(int var1);

    @Override
    public final long getLongLE(int index) {
        this.checkIndex0(index, 8);
        return this.getLongLENoBounds(index);
    }

    protected final long getLongLENoBounds(int index) {
        return Long.reverseBytes(this.getLongNoBounds(index));
    }

    @Override
    public final float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    @Override
    public final double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    @Override
    public final Buffer getBytes(int index, Buffer dst) {
        this.getBytes(index, dst, dst.writableBytes());
        return this;
    }

    @Override
    public final Buffer getBytes(int index, Buffer dst, int length) {
        this.getBytes(index, dst, dst.writerIndex(), length);
        dst.writerIndex(dst.writerIndex() + length);
        return this;
    }

    @Override
    public final Buffer getBytes(int index, byte[] dst) {
        this.getBytes(index, dst, 0, dst.length);
        return this;
    }

    @Override
    public final byte readByte() {
        this.checkReadableBytes0(1);
        int i = this.readerIndex;
        byte b = this.getByteNoBounds(i);
        this.readerIndex = i + 1;
        return b;
    }

    @Override
    public final boolean readBoolean() {
        return this.readByte() != 0;
    }

    @Override
    public final short readUnsignedByte() {
        return (short)(this.readByte() & 0xFF);
    }

    @Override
    public final short readShort() {
        this.checkReadableBytes0(2);
        short v = this.getShortNoBounds(this.readerIndex);
        this.readerIndex += 2;
        return v;
    }

    @Override
    public final char readChar() {
        return (char)this.readShort();
    }

    @Override
    public final short readShortLE() {
        this.checkReadableBytes0(2);
        short v = this.getShortLENoBounds(this.readerIndex);
        this.readerIndex += 2;
        return v;
    }

    @Override
    public final int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public final int readUnsignedShortLE() {
        return this.readShortLE() & 0xFFFF;
    }

    @Override
    public final int readMedium() {
        int value = this.readUnsignedMedium();
        if ((value & 0x800000) != 0) {
            value |= 0xFF000000;
        }
        return value;
    }

    @Override
    public final int readMediumLE() {
        int value = this.readUnsignedMediumLE();
        if ((value & 0x800000) != 0) {
            value |= 0xFF000000;
        }
        return value;
    }

    @Override
    public final int readUnsignedMedium() {
        this.checkReadableBytes0(3);
        int v = this.getUnsignedMediumNoBounds(this.readerIndex);
        this.readerIndex += 3;
        return v;
    }

    @Override
    public final int readUnsignedMediumLE() {
        this.checkReadableBytes0(3);
        int v = this.getUnsignedMediumLENoBounds(this.readerIndex);
        this.readerIndex += 3;
        return v;
    }

    @Override
    public final int readInt() {
        this.checkReadableBytes0(4);
        int v = this.getIntNoBounds(this.readerIndex);
        this.readerIndex += 4;
        return v;
    }

    @Override
    public final int readIntLE() {
        this.checkReadableBytes0(4);
        int v = this.getIntLENoBounds(this.readerIndex);
        this.readerIndex += 4;
        return v;
    }

    @Override
    public final long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public final long readUnsignedIntLE() {
        return (long)this.readIntLE() & 0xFFFFFFFFL;
    }

    @Override
    public final long readLong() {
        this.checkReadableBytes0(8);
        long v = this.getLongNoBounds(this.readerIndex);
        this.readerIndex += 8;
        return v;
    }

    @Override
    public final long readLongLE() {
        this.checkReadableBytes0(8);
        long v = this.getLongLENoBounds(this.readerIndex);
        this.readerIndex += 8;
        return v;
    }

    @Override
    public final float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final Buffer readBytes(byte[] dst, int dstIndex, int length) {
        this.checkReadableBytes0(length);
        this.getBytes(this.readerIndex, dst, dstIndex, length);
        this.readerIndex += length;
        return this;
    }

    @Override
    public final Buffer readBytes(byte[] dst) {
        this.readBytes(dst, 0, dst.length);
        return this;
    }

    @Override
    public final Buffer readBytes(Buffer dst) {
        this.readBytes(dst, dst.writableBytes());
        return this;
    }

    @Override
    public final Buffer readBytes(Buffer dst, int length) {
        if (length > dst.writableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds dst.writableBytes(%d) where dst is: %s", length, dst.writableBytes(), dst));
        }
        this.readBytes(dst, dst.writerIndex(), length);
        dst.writerIndex(dst.writerIndex() + length);
        return this;
    }

    @Override
    public final Buffer readBytes(Buffer dst, int dstIndex, int length) {
        this.checkReadableBytes0(length);
        this.getBytes(this.readerIndex, dst, dstIndex, length);
        this.readerIndex += length;
        return this;
    }

    @Override
    public final Buffer readBytes(ByteBuffer dst) {
        int length = dst.remaining();
        this.checkReadableBytes0(length);
        this.getBytes(this.readerIndex, dst);
        this.readerIndex += length;
        return this;
    }

    @Override
    public final Buffer skipBytes(int length) {
        this.checkReadableBytes0(length);
        this.skipBytes0(length);
        return this;
    }

    final void skipBytes0(int length) {
        this.readerIndex += length;
    }

    @Override
    public final int bytesBefore(byte value) {
        return this.bytesBefore(this.readerIndex, this.readableBytes(), value);
    }

    @Override
    public final int bytesBefore(int length, byte value) {
        this.checkReadableBytes0(length);
        return this.bytesBefore(this.readerIndex, length, value);
    }

    @Override
    public final int bytesBefore(int index, int length, byte value) {
        int endIndex = this.indexOf(index, index + length, value);
        if (endIndex < 0) {
            return -1;
        }
        return endIndex - index;
    }

    @Override
    public final int forEachByte(ByteProcessor processor) {
        return this.forEachByteAsc0(this.readerIndex, this.writerIndex, processor);
    }

    @Override
    public final int forEachByte(int index, int length, ByteProcessor processor) {
        this.checkIndex0(index, length);
        return this.forEachByteAsc0(index, index + length, processor);
    }

    private int forEachByteAsc0(int start, int end, ByteProcessor processor) {
        while (start < end) {
            if (!processor.process(this.getByteNoBounds(start))) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    @Override
    public final int forEachByteDesc(ByteProcessor processor) {
        return this.forEachByteDesc0(this.writerIndex - 1, this.readerIndex, processor);
    }

    @Override
    public final int forEachByteDesc(int index, int length, ByteProcessor processor) {
        this.checkIndex0(index, length);
        return this.forEachByteDesc0(index + length - 1, index, processor);
    }

    @Override
    public final Buffer copy() {
        return this.copy(this.readerIndex, this.readableBytes());
    }

    @Override
    public final Buffer slice() {
        return this.slice(this.readerIndex, this.readableBytes());
    }

    private int forEachByteDesc0(int rStart, int rEnd, ByteProcessor processor) {
        while (rStart >= rEnd) {
            if (!processor.process(this.getByteNoBounds(rStart))) {
                return rStart;
            }
            --rStart;
        }
        return -1;
    }

    @Override
    public final int indexOf(int fromIndex, int toIndex, byte value) {
        return fromIndex < toIndex ? this.firstIndexOf(fromIndex, toIndex, value) : this.lastIndexOf(fromIndex, toIndex, value);
    }

    protected int firstIndexOf(int fromIndex, int toIndex, byte value) {
        return this.forEachByte(fromIndex, toIndex - fromIndex, new IndexOfByteProcessor(value));
    }

    protected int lastIndexOf(int fromIndex, int toIndex, byte value) {
        return this.forEachByteDesc(toIndex, fromIndex - toIndex, new IndexOfByteProcessor(value));
    }

    @Override
    public ByteBuffer toNioBuffer() {
        return this.toNioBuffer(this.readerIndex, this.readableBytes());
    }

    @Override
    public final ByteBuffer[] toNioBuffers() {
        return this.toNioBuffers(this.readerIndex, this.readableBytes());
    }

    @Override
    public boolean equals(Object o) {
        int i;
        if (!(o instanceof Buffer)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        Buffer that = (Buffer)o;
        int readableBytes = this.readableBytes();
        if (readableBytes != that.readableBytes()) {
            return false;
        }
        int aStartIndex = this.readerIndex();
        int bStartIndex = that.readerIndex();
        int longCount = readableBytes >>> 3;
        int byteCount = readableBytes & 7;
        for (i = longCount; i > 0; --i) {
            if (this.getLong(aStartIndex) != that.getLong(bStartIndex)) {
                return false;
            }
            aStartIndex += 8;
            bStartIndex += 8;
        }
        for (i = byteCount; i > 0; --i) {
            if (this.getByte(aStartIndex) != that.getByte(bStartIndex)) {
                return false;
            }
            ++aStartIndex;
            ++bStartIndex;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int i;
        int aLen = this.readableBytes();
        int longCount = aLen >>> 3;
        int byteCount = aLen & 3;
        int hashCode = 1;
        int arrayIndex = this.readerIndex;
        for (i = longCount; i > 0; --i) {
            hashCode = 31 * hashCode + Long.hashCode(this.getLong(arrayIndex));
            arrayIndex += 8;
        }
        for (i = byteCount; i > 0; --i) {
            hashCode = 31 * hashCode + this.getByte(arrayIndex++);
        }
        if (hashCode == 0) {
            hashCode = 1;
        }
        return hashCode;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder().append(this.getClass().getSimpleName()).append("(ridx: ").append(this.readerIndex).append(", widx: ").append(this.writerIndex).append(", cap: ").append(this.capacity());
        if (this.maxCapacity() != Integer.MAX_VALUE) {
            buf.append('/').append(this.maxCapacity());
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public final String toString(Charset charset) {
        return this.toString(this.readerIndex, this.readableBytes(), charset);
    }

    final void checkReadableBytes0(int minimumReadableBytes) {
        if (this.readerIndex > this.writerIndex - minimumReadableBytes) {
            throw new IndexOutOfBoundsException(String.format("readerIndex(%d) + length(%d) exceeds writerIndex(%d): %s", this.readerIndex, minimumReadableBytes, this.writerIndex, this));
        }
    }

    final void checkIndex0(int index, int fieldLength) {
        if (AbstractBuffer.isOutOfBounds(index, fieldLength, this.capacity())) {
            throw new IndexOutOfBoundsException(String.format("index: %d, length: %d (expected: range(0, %d))", index, fieldLength, this.capacity()));
        }
    }

    final void checkDstIndex(int index, int length, int dstIndex, int dstCapacity) {
        this.checkIndex0(index, length);
        if (AbstractBuffer.isOutOfBounds(dstIndex, length, dstCapacity)) {
            throw new IndexOutOfBoundsException(String.format("dstIndex: %d, length: %d (expected: range(0, %d))", dstIndex, length, dstCapacity));
        }
    }

    static boolean isOutOfBounds(int index, int length, int capacity) {
        return (index | length | index + length | capacity - (index + length)) < 0;
    }
}

