/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractSynchronousCompletableOperator;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ComposedCancellable;
import io.servicetalk.concurrent.api.TerminalSignalConsumer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class AfterFinallyCompletable
extends AbstractSynchronousCompletableOperator {
    private final TerminalSignalConsumer doFinally;

    AfterFinallyCompletable(Completable original, TerminalSignalConsumer doFinally) {
        super(original);
        this.doFinally = Objects.requireNonNull(doFinally);
    }

    @Override
    public CompletableSource.Subscriber apply(CompletableSource.Subscriber subscriber) {
        return new AfterFinallyCompletableSubscriber(subscriber, this.doFinally);
    }

    private static final class AfterFinallyCompletableSubscriber
    implements CompletableSource.Subscriber {
        private final CompletableSource.Subscriber original;
        private final TerminalSignalConsumer doFinally;
        private static final AtomicIntegerFieldUpdater<AfterFinallyCompletableSubscriber> doneUpdater = AtomicIntegerFieldUpdater.newUpdater(AfterFinallyCompletableSubscriber.class, "done");
        private volatile int done;

        AfterFinallyCompletableSubscriber(CompletableSource.Subscriber original, TerminalSignalConsumer doFinally) {
            this.original = original;
            this.doFinally = doFinally;
        }

        @Override
        public void onSubscribe(Cancellable originalCancellable) {
            this.original.onSubscribe(new ComposedCancellable(originalCancellable, () -> {
                if (doneUpdater.compareAndSet(this, 0, 1)) {
                    this.doFinally.cancel();
                }
            }));
        }

        @Override
        public void onComplete() {
            try {
                this.original.onComplete();
            }
            finally {
                if (doneUpdater.compareAndSet(this, 0, 1)) {
                    this.doFinally.onComplete();
                }
            }
        }

        @Override
        public void onError(Throwable cause) {
            try {
                this.original.onError(cause);
            }
            finally {
                if (doneUpdater.compareAndSet(this, 0, 1)) {
                    this.doFinally.onError(cause);
                }
            }
        }
    }
}

