/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.api.AbstractExecutor;
import io.servicetalk.concurrent.api.DefaultThreadFactory;
import io.servicetalk.utils.internal.PlatformDependent;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultExecutor
extends AbstractExecutor
implements Consumer<Runnable> {
    private static final long DEFAULT_KEEP_ALIVE_TIME_SECONDS = 60L;
    private static final ScheduledExecutorService GLOBAL_SINGLE_THREADED_SCHEDULED_EXECUTOR = Executors.newSingleThreadScheduledExecutor(new DefaultThreadFactory("servicetalk-global-scheduler", true, 5));
    private static final RejectedExecutionHandler DEFAULT_REJECTION_HANDLER = new ThreadPoolExecutor.AbortPolicy();
    private final InternalExecutor executor;
    private final InternalScheduler scheduler;

    DefaultExecutor(int coreSize, int maxSize, ThreadFactory threadFactory) {
        this(new ThreadPoolExecutor(coreSize, maxSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory, DEFAULT_REJECTION_HANDLER));
    }

    DefaultExecutor(Executor jdkExecutor) {
        this(jdkExecutor, true);
    }

    DefaultExecutor(Executor jdkExecutor, boolean interruptOnCancel) {
        this(jdkExecutor, new SingleThreadedScheduler(jdkExecutor), interruptOnCancel);
    }

    DefaultExecutor(Executor jdkExecutor, ScheduledExecutorService scheduler) {
        this(jdkExecutor, scheduler, true);
    }

    DefaultExecutor(Executor jdkExecutor, ScheduledExecutorService scheduler, boolean interruptOnCancel) {
        this(jdkExecutor, DefaultExecutor.newScheduler(scheduler, interruptOnCancel), interruptOnCancel);
    }

    private DefaultExecutor(@Nullable Executor jdkExecutor, @Nullable InternalScheduler scheduler, boolean interruptOnCancel) {
        if (jdkExecutor == null) {
            if (scheduler != null) {
                scheduler.close();
            }
            throw new NullPointerException("jdkExecutor");
        }
        if (scheduler == null) {
            DefaultExecutor.shutdownExecutor(jdkExecutor);
            throw new NullPointerException("scheduler");
        }
        this.executor = DefaultExecutor.newInternalExecutor(jdkExecutor, interruptOnCancel);
        this.scheduler = scheduler;
    }

    public String toString() {
        return DefaultExecutor.class.getSimpleName() + "{executor=" + this.executor + ", scheduler=" + this.scheduler + '}';
    }

    @Override
    public Cancellable execute(Runnable task) {
        return (Cancellable)this.executor.apply(task);
    }

    @Override
    public Cancellable schedule(Runnable task, long duration, TimeUnit unit) {
        return this.scheduler.schedule(task, duration, unit);
    }

    @Override
    void doClose() {
        try {
            this.executor.close();
        }
        finally {
            this.scheduler.close();
        }
    }

    @Override
    public void accept(Runnable runnable) {
        this.execute(runnable);
    }

    private static void shutdownExecutor(Executor jdkExecutor) {
        if (jdkExecutor instanceof ExecutorService) {
            ((ExecutorService)jdkExecutor).shutdown();
        } else if (jdkExecutor instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)jdkExecutor)).close();
            }
            catch (Exception e) {
                PlatformDependent.throwException(e);
            }
        }
    }

    private static InternalExecutor newInternalExecutor(final Executor jdkExecutor, final boolean interruptOnCancel) {
        if (jdkExecutor instanceof ExecutorService) {
            return new InternalExecutor(){
                private final ExecutorService service;
                {
                    this.service = (ExecutorService)jdkExecutor;
                }

                public String toString() {
                    return "InternalExecutor{service=ExecutorService@" + Integer.toHexString(System.identityHashCode(jdkExecutor)) + '}';
                }

                @Override
                public void close() {
                    this.service.shutdown();
                }

                @Override
                public Cancellable apply(Runnable runnable) {
                    Future<?> future = this.service.submit(runnable);
                    return () -> future.cancel(interruptOnCancel);
                }
            };
        }
        return new InternalExecutor(){

            public String toString() {
                return "InternalExecutor{service=Executor@" + Integer.toHexString(System.identityHashCode(jdkExecutor)) + '}';
            }

            @Override
            public void close() {
                DefaultExecutor.shutdownExecutor(jdkExecutor);
            }

            @Override
            public Cancellable apply(Runnable runnable) {
                jdkExecutor.execute(runnable);
                return Cancellable.IGNORE_CANCEL;
            }
        };
    }

    private static InternalScheduler newScheduler(final ScheduledExecutorService service, final boolean interruptOnCancel) {
        return new InternalScheduler(){

            public String toString() {
                return "InternalScheduler{service=ScheduledExecutorService@" + Integer.toHexString(System.identityHashCode(service)) + '}';
            }

            @Override
            public void close() {
                service.shutdown();
            }

            @Override
            public Cancellable schedule(Runnable task, long delay, TimeUnit unit) {
                ScheduledFuture<?> future = service.schedule(task, delay, unit);
                return () -> future.cancel(interruptOnCancel);
            }
        };
    }

    private static final class SingleThreadedScheduler
    implements InternalScheduler {
        private static final Logger LOGGER = LoggerFactory.getLogger(SingleThreadedScheduler.class);
        private final Executor offloadExecutor;

        SingleThreadedScheduler(Executor offloadExecutor) {
            this.offloadExecutor = offloadExecutor;
        }

        public String toString() {
            return "SingleThreadedScheduler{offload=Executor@" + Integer.toHexString(System.identityHashCode(this.offloadExecutor)) + '}';
        }

        @Override
        public void close() {
        }

        @Override
        public Cancellable schedule(Runnable task, long delay, TimeUnit unit) {
            ScheduledFuture<?> future = GLOBAL_SINGLE_THREADED_SCHEDULED_EXECUTOR.schedule(() -> {
                try {
                    this.offloadExecutor.execute(task);
                }
                catch (RejectedExecutionException e) {
                    LOGGER.error("Executor {} rejected a scheduled task: {}. Fallback to executing the task on the current scheduler thread: {}", this.offloadExecutor, task, Thread.currentThread().getName(), e);
                    try {
                        task.run();
                    }
                    catch (Throwable taskFailure) {
                        LOGGER.error("Scheduled task {} threw an exception on the scheduler thread.", (Object)task, (Object)taskFailure);
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("Unexpected exception while offloading scheduled task: {} to executor: {}.", task, this.offloadExecutor, t);
                }
            }, delay, unit);
            return () -> future.cancel(true);
        }
    }

    private static interface InternalScheduler
    extends AutoCloseable {
        @Override
        public void close();

        public Cancellable schedule(Runnable var1, long var2, TimeUnit var4);
    }

    private static interface InternalExecutor
    extends Function<Runnable, Cancellable>,
    AutoCloseable {
        @Override
        public void close();
    }
}

