/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.internal;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.internal.TerminalNotification;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nullable;

public final class ConcurrentTerminalSubscriber<T>
implements PublisherSource.Subscriber<T> {
    private static final int SUBSCRIBER_STATE_INVALID = Integer.MIN_VALUE;
    private static final int SUBSCRIBER_STATE_WAITING_ON_SUBSCRIBE = -1;
    private static final int SUBSCRIBER_STATE_IDLE = 0;
    private static final int SUBSCRIBER_STATE_ON_NEXT = 1;
    private static final int SUBSCRIBER_STATE_TERMINATING = 2;
    private static final int SUBSCRIBER_STATE_TERMINATED = 3;
    private static final AtomicIntegerFieldUpdater<ConcurrentTerminalSubscriber> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(ConcurrentTerminalSubscriber.class, "state");
    private final PublisherSource.Subscriber<T> delegate;
    @Nullable
    private TerminalNotification terminalNotification;
    private volatile int state;

    public ConcurrentTerminalSubscriber(PublisherSource.Subscriber<T> delegate) {
        this(delegate, true);
    }

    public ConcurrentTerminalSubscriber(PublisherSource.Subscriber<T> delegate, boolean concurrentOnSubscribe) {
        this.delegate = Objects.requireNonNull(delegate);
        this.state = concurrentOnSubscribe ? -1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSubscribe(PublisherSource.Subscription subscription) {
        boolean wasWaiting = this.state == -1;
        try {
            this.delegate.onSubscribe(subscription);
        }
        finally {
            block8: {
                if (wasWaiting) {
                    while (true) {
                        int localState;
                        if ((localState = this.state) == -1) {
                            if (!stateUpdater.compareAndSet(this, -1, 0)) continue;
                            break block8;
                        }
                        if (localState != 2) break block8;
                        if (stateUpdater.compareAndSet(this, 2, 3)) break;
                    }
                    assert (this.terminalNotification != null);
                    this.terminalNotification.terminate(this.delegate);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(@Nullable T t) {
        int localState;
        int originalState;
        block9: {
            originalState = Integer.MIN_VALUE;
            while ((localState = this.state) == 0 || localState == -1) {
                if (!stateUpdater.compareAndSet(this, localState, 1)) continue;
                originalState = localState;
                break block9;
            }
            if (localState != 1) {
                return;
            }
        }
        try {
            this.delegate.onNext(t);
        }
        finally {
            block11: {
                if (originalState != Integer.MIN_VALUE) {
                    while (true) {
                        if ((localState = this.state) == 1) {
                            if (!stateUpdater.compareAndSet(this, 1, originalState)) continue;
                            break block11;
                        }
                        if (localState != 2) break block11;
                        if (stateUpdater.compareAndSet(this, 2, 3)) break;
                    }
                    assert (this.terminalNotification != null);
                    this.terminalNotification.terminate(this.delegate);
                }
            }
        }
    }

    @Override
    public void onError(Throwable t) {
        this.processOnError(t);
    }

    public boolean processOnError(Throwable t) {
        int localState;
        do {
            if ((localState = this.state) == 3 || localState == 2) {
                return false;
            }
            this.terminalNotification = TerminalNotification.error(t);
        } while (!stateUpdater.compareAndSet(this, localState, 2));
        if (localState == 0 && stateUpdater.compareAndSet(this, 2, 3)) {
            this.delegate.onError(t);
            return true;
        }
        return false;
    }

    @Override
    public void onComplete() {
        this.processOnComplete();
    }

    public boolean processOnComplete() {
        int localState;
        do {
            if ((localState = this.state) == 3 || localState == 2) {
                return false;
            }
            this.terminalNotification = TerminalNotification.complete();
        } while (!stateUpdater.compareAndSet(this, localState, 2));
        if (localState == 0 && stateUpdater.compareAndSet(this, 2, 3)) {
            this.delegate.onComplete();
            return true;
        }
        return false;
    }
}

