/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.internal;

import io.servicetalk.concurrent.Cancellable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

public class SequentialCancellable
implements Cancellable {
    private static final Cancellable CANCELLED = () -> {};
    private static final AtomicReferenceFieldUpdater<SequentialCancellable, Cancellable> currentUpdater = AtomicReferenceFieldUpdater.newUpdater(SequentialCancellable.class, Cancellable.class, "current");
    @Nullable
    private volatile Cancellable current;

    public SequentialCancellable() {
    }

    public SequentialCancellable(Cancellable cancellable) {
        this.current = Objects.requireNonNull(cancellable);
    }

    public final void nextCancellable(Cancellable next) {
        Cancellable oldVal = currentUpdater.getAndSet(this, Objects.requireNonNull(next));
        if (oldVal == CANCELLED) {
            next.cancel();
        }
    }

    @Override
    public final void cancel() {
        Cancellable oldVal = currentUpdater.getAndSet(this, CANCELLED);
        if (oldVal != null) {
            oldVal.cancel();
        }
    }

    public boolean isCancelled() {
        return this.current == CANCELLED;
    }
}

