/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.dns.discovery.netty;

import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.dns.discovery.netty.DefaultDnsClient;
import io.servicetalk.dns.discovery.netty.DnsClient;
import io.servicetalk.dns.discovery.netty.DnsClientFilterFactory;
import io.servicetalk.dns.discovery.netty.DnsClients;
import io.servicetalk.dns.discovery.netty.DnsResolverAddressTypes;
import io.servicetalk.dns.discovery.netty.DnsServerAddressStreamProvider;
import io.servicetalk.dns.discovery.netty.DnsServiceDiscovererObserver;
import io.servicetalk.transport.api.HostAndPort;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.netty.internal.GlobalExecutionContext;
import io.servicetalk.utils.internal.DurationUtils;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nullable;

public final class DefaultDnsServiceDiscovererBuilder {
    @Nullable
    private DnsServerAddressStreamProvider dnsServerAddressStreamProvider;
    @Nullable
    private DnsResolverAddressTypes dnsResolverAddressTypes;
    @Nullable
    private Integer maxUdpPayloadSize;
    @Nullable
    private Integer ndots;
    @Nullable
    private Boolean optResourceEnabled;
    @Nullable
    private IoExecutor ioExecutor;
    @Nullable
    private Duration queryTimeout;
    private int minTTLSeconds = 10;
    private Duration ttlJitter = Duration.ofSeconds(4L);
    private int srvConcurrency = 2048;
    private boolean inactiveEventsOnError;
    private boolean completeOncePreferredResolved = true;
    private boolean srvFilterDuplicateEvents;
    private Duration srvHostNameRepeatInitialDelay = Duration.ofSeconds(10L);
    private Duration srvHostNameRepeatJitter = Duration.ofSeconds(5L);
    @Nullable
    private DnsClientFilterFactory filterFactory;
    @Nullable
    private DnsServiceDiscovererObserver observer;
    private ServiceDiscovererEvent.Status missingRecordStatus = ServiceDiscovererEvent.Status.EXPIRED;

    public DefaultDnsServiceDiscovererBuilder minTTL(int minTTLSeconds) {
        if (minTTLSeconds <= 0) {
            throw new IllegalArgumentException("minTTLSeconds: " + minTTLSeconds + " (expected > 0)");
        }
        this.minTTLSeconds = minTTLSeconds;
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder ttlJitter(Duration ttlJitter) {
        DurationUtils.ensurePositive(ttlJitter, "jitter");
        this.ttlJitter = ttlJitter;
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder dnsServerAddressStreamProvider(@Nullable DnsServerAddressStreamProvider dnsServerAddressStreamProvider) {
        this.dnsServerAddressStreamProvider = dnsServerAddressStreamProvider;
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder optResourceEnabled(boolean optResourceEnabled) {
        this.optResourceEnabled = optResourceEnabled;
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder maxUdpPayloadSize(int maxUdpPayloadSize) {
        if (maxUdpPayloadSize <= 0) {
            throw new IllegalArgumentException("maxUdpPayloadSize: " + maxUdpPayloadSize + " (expected > 0)");
        }
        this.maxUdpPayloadSize = maxUdpPayloadSize;
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder ndots(int ndots) {
        this.ndots = ndots;
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder queryTimeout(Duration queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder dnsResolverAddressTypes(@Nullable DnsResolverAddressTypes dnsResolverAddressTypes) {
        this.dnsResolverAddressTypes = dnsResolverAddressTypes;
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder ioExecutor(IoExecutor ioExecutor) {
        this.ioExecutor = ioExecutor;
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder observer(DnsServiceDiscovererObserver observer) {
        this.observer = Objects.requireNonNull(observer);
        return this;
    }

    public DefaultDnsServiceDiscovererBuilder missingRecordStatus(ServiceDiscovererEvent.Status status) {
        if (ServiceDiscovererEvent.Status.AVAILABLE.equals(status)) {
            throw new IllegalArgumentException(ServiceDiscovererEvent.Status.AVAILABLE + " status can not be used as missing records' status.");
        }
        this.missingRecordStatus = Objects.requireNonNull(status);
        return this;
    }

    public ServiceDiscoverer<String, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> buildSrvDiscoverer() {
        return DnsClients.asSrvDiscoverer(this.build());
    }

    public ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> buildARecordDiscoverer() {
        return DnsClients.asHostAndPortDiscoverer(this.build());
    }

    DefaultDnsServiceDiscovererBuilder inactiveEventsOnError(boolean inactiveEventsOnError) {
        this.inactiveEventsOnError = inactiveEventsOnError;
        return this;
    }

    DefaultDnsServiceDiscovererBuilder srvConcurrency(int srvConcurrency) {
        if (srvConcurrency <= 0) {
            throw new IllegalArgumentException("srvConcurrency: " + srvConcurrency + " (expected >0)");
        }
        this.srvConcurrency = srvConcurrency;
        return this;
    }

    DefaultDnsServiceDiscovererBuilder completeOncePreferredResolved(boolean completeOncePreferredResolved) {
        this.completeOncePreferredResolved = completeOncePreferredResolved;
        return this;
    }

    DefaultDnsServiceDiscovererBuilder srvHostNameRepeatDelay(Duration initialDelay, Duration jitter) {
        this.srvHostNameRepeatInitialDelay = Objects.requireNonNull(initialDelay);
        this.srvHostNameRepeatJitter = Objects.requireNonNull(jitter);
        return this;
    }

    DefaultDnsServiceDiscovererBuilder srvFilterDuplicateEvents(boolean srvFilterDuplicateEvents) {
        this.srvFilterDuplicateEvents = srvFilterDuplicateEvents;
        return this;
    }

    DefaultDnsServiceDiscovererBuilder appendFilter(DnsClientFilterFactory factory) {
        Objects.requireNonNull(factory);
        this.filterFactory = DefaultDnsServiceDiscovererBuilder.appendFilter(this.filterFactory, factory);
        return this;
    }

    private static DnsClientFilterFactory appendFilter(@Nullable DnsClientFilterFactory current, DnsClientFilterFactory next) {
        return current == null ? next : dnsClient -> current.create(next.create(dnsClient));
    }

    DnsClient build() {
        DefaultDnsClient rawClient = new DefaultDnsClient(this.ioExecutor == null ? GlobalExecutionContext.globalExecutionContext().ioExecutor() : this.ioExecutor, this.minTTLSeconds, this.ttlJitter.toNanos(), this.srvConcurrency, this.inactiveEventsOnError, this.completeOncePreferredResolved, this.srvFilterDuplicateEvents, this.srvHostNameRepeatInitialDelay, this.srvHostNameRepeatJitter, this.maxUdpPayloadSize, this.ndots, this.optResourceEnabled, this.queryTimeout, this.dnsResolverAddressTypes, this.dnsServerAddressStreamProvider, this.observer, this.missingRecordStatus);
        return this.filterFactory == null ? rawClient : this.filterFactory.create(rawClient);
    }
}

