/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpPayloadWriter;
import io.servicetalk.http.api.HttpStreamingSerializer;
import io.servicetalk.http.api.NonFramedStreamingSerializer;
import io.servicetalk.oio.api.PayloadWriter;
import io.servicetalk.serializer.api.Serializer;
import io.servicetalk.serializer.api.StreamingSerializer;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;

final class DefaultHttpStreamingSerializer<T>
implements HttpStreamingSerializer<T> {
    private final StreamingSerializer<T> serializer;
    private final Consumer<HttpHeaders> headersSerializeConsumer;

    DefaultHttpStreamingSerializer(Serializer<T> serializer, ToIntFunction<T> bytesEstimator, Consumer<HttpHeaders> headersSerializeConsumer) {
        this(new NonFramedStreamingSerializer<T>(serializer, bytesEstimator), headersSerializeConsumer);
    }

    DefaultHttpStreamingSerializer(StreamingSerializer<T> serializer, Consumer<HttpHeaders> headersSerializeConsumer) {
        this.serializer = Objects.requireNonNull(serializer);
        this.headersSerializeConsumer = Objects.requireNonNull(headersSerializeConsumer);
    }

    @Override
    public BlockingIterable<Buffer> serialize(HttpHeaders headers, BlockingIterable<T> value, BufferAllocator allocator) {
        this.headersSerializeConsumer.accept(headers);
        return this.serializer.serialize(value, allocator);
    }

    @Override
    public Publisher<Buffer> serialize(HttpHeaders headers, Publisher<T> value, BufferAllocator allocator) {
        this.headersSerializeConsumer.accept(headers);
        return this.serializer.serialize(value, allocator);
    }

    @Override
    public HttpPayloadWriter<T> serialize(HttpHeaders headers, final HttpPayloadWriter<Buffer> payloadWriter, BufferAllocator allocator) {
        this.headersSerializeConsumer.accept(headers);
        final PayloadWriter<T> result = this.serializer.serialize(payloadWriter, allocator);
        return new HttpPayloadWriter<T>(){

            @Override
            public HttpHeaders trailers() {
                return payloadWriter.trailers();
            }

            @Override
            public void write(T t) throws IOException {
                result.write(t);
            }

            @Override
            public void close(Throwable cause) throws IOException {
                result.close(cause);
            }

            @Override
            public void close() throws IOException {
                result.close();
            }

            @Override
            public void flush() throws IOException {
                result.flush();
            }
        };
    }
}

