/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.BlockingIterator;
import io.servicetalk.concurrent.CloseableIterator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.api.DelegatingToBufferHttpPayloadWriter;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpPayloadWriter;
import io.servicetalk.http.api.HttpSerializer;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.annotation.Nullable;

final class HttpStringSerializer
implements HttpSerializer<String> {
    static final HttpStringSerializer UTF8_STRING_SERIALIZER = new HttpStringSerializer(StandardCharsets.UTF_8, headers -> headers.set(HttpHeaderNames.CONTENT_TYPE, HttpHeaderValues.TEXT_PLAIN_UTF_8));
    private final Charset charset;
    private final Consumer<HttpHeaders> addContentType;

    HttpStringSerializer(Charset charset, Consumer<HttpHeaders> addContentType) {
        this.charset = charset;
        this.addContentType = addContentType;
    }

    @Override
    public Buffer serialize(HttpHeaders headers, String value, BufferAllocator allocator) {
        this.addContentType.accept(headers);
        return allocator.fromSequence(value, this.charset);
    }

    @Override
    public BlockingIterable<Buffer> serialize(HttpHeaders headers, BlockingIterable<String> value, BufferAllocator allocator) {
        this.addContentType.accept(headers);
        return () -> {
            CloseableIterator iterator = value.iterator();
            return new BlockingIterator<Buffer>((BlockingIterator)iterator, allocator){
                final /* synthetic */ BlockingIterator val$iterator;
                final /* synthetic */ BufferAllocator val$allocator;
                {
                    this.val$iterator = blockingIterator;
                    this.val$allocator = bufferAllocator;
                }

                @Override
                public boolean hasNext(long timeout, TimeUnit unit) throws TimeoutException {
                    return this.val$iterator.hasNext(timeout, unit);
                }

                @Override
                public Buffer next(long timeout, TimeUnit unit) throws TimeoutException {
                    return HttpStringSerializer.this.toBuffer((String)this.val$iterator.next(timeout, unit), this.val$allocator);
                }

                @Override
                public void close() throws Exception {
                    this.val$iterator.close();
                }

                @Override
                public boolean hasNext() {
                    return this.val$iterator.hasNext();
                }

                @Override
                public Buffer next() {
                    return HttpStringSerializer.this.toBuffer((String)this.val$iterator.next(), this.val$allocator);
                }
            };
        };
    }

    @Override
    public Publisher<Buffer> serialize(HttpHeaders headers, Publisher<String> value, BufferAllocator allocator) {
        this.addContentType.accept(headers);
        return value.map(str -> this.toBuffer((String)str, allocator));
    }

    @Override
    public HttpPayloadWriter<String> serialize(HttpHeaders headers, HttpPayloadWriter<Buffer> payloadWriter, BufferAllocator allocator) {
        this.addContentType.accept(headers);
        return new DelegatingToBufferHttpPayloadWriter<String>(payloadWriter, allocator){

            @Override
            public void write(String object) throws IOException {
                this.delegate.write(HttpStringSerializer.this.toBuffer(object, this.allocator));
            }
        };
    }

    @Nullable
    private Buffer toBuffer(@Nullable String value, BufferAllocator allocator) {
        return value == null ? null : allocator.fromSequence(value, this.charset);
    }
}

