/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpContextKeys;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.netty.ProxyConnectConnectionFactoryFilter;
import io.servicetalk.http.utils.HttpRequestUriUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AbsoluteAddressHttpRequesterFilter
implements StreamingHttpClientFilterFactory,
StreamingHttpConnectionFilterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbsoluteAddressHttpRequesterFilter.class);
    private final String scheme;
    private final String authority;

    AbsoluteAddressHttpRequesterFilter(String scheme, CharSequence authority) {
        this.scheme = Objects.requireNonNull(scheme);
        this.authority = authority.toString();
    }

    @Override
    public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
        return new StreamingHttpClientFilter(client){

            @Override
            protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, StreamingHttpRequest request) {
                return AbsoluteAddressHttpRequesterFilter.this.request(delegate, request);
            }
        };
    }

    @Override
    public StreamingHttpConnectionFilter create(FilterableStreamingHttpConnection connection) {
        return new StreamingHttpConnectionFilter(connection){

            @Override
            public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
                return AbsoluteAddressHttpRequesterFilter.this.request(this.delegate(), request);
            }
        };
    }

    @Override
    public HttpExecutionStrategy requiredOffloads() {
        return HttpExecutionStrategies.offloadNone();
    }

    private Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, StreamingHttpRequest request) {
        return Single.defer(() -> {
            ProxyConnectConnectionFactoryFilter.logUnexpectedAddress(request.context().put(HttpContextKeys.HTTP_TARGET_ADDRESS_BEHIND_PROXY, this.authority), this.authority, LOGGER);
            String effectiveRequestUri = HttpRequestUriUtils.getEffectiveRequestUri(request, this.scheme, this.authority, false);
            request.requestTarget(effectiveRequestUri);
            return delegate.request(request).shareContextOnSubscribe();
        });
    }
}

