/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.internal.SubscribableSingle;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.transport.netty.internal.ChannelCloseUtils;
import io.servicetalk.transport.netty.internal.ChannelInitializer;

abstract class ChannelInitSingle<T>
extends SubscribableSingle<T> {
    private final Channel channel;
    private final ChannelInitializer channelInitializer;

    ChannelInitSingle(Channel channel, ChannelInitializer channelInitializer) {
        this.channel = channel;
        this.channelInitializer = channelInitializer;
    }

    @Override
    protected final void handleSubscribe(SingleSource.Subscriber<? super T> subscriber) {
        try {
            this.channelInitializer.init(this.channel);
        }
        catch (Throwable cause) {
            ChannelCloseUtils.close(this.channel, cause);
            SubscriberUtils.deliverErrorFromSource(subscriber, cause);
            return;
        }
        subscriber.onSubscribe(this.channel::close);
        this.channel.pipeline().addLast(this.newChannelHandler(subscriber));
    }

    protected abstract ChannelHandler newChannelHandler(SingleSource.Subscriber<? super T> var1);
}

