/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.DefaultServiceDiscovererEvent;
import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.dns.discovery.netty.DefaultDnsServiceDiscovererBuilder;
import io.servicetalk.transport.api.HostAndPort;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GlobalDnsServiceDiscoverer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalDnsServiceDiscoverer.class);

    private GlobalDnsServiceDiscoverer() {
    }

    static ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> globalDnsServiceDiscoverer() {
        return HostAndPortClientInitializer.HOST_PORT_SD;
    }

    static ServiceDiscoverer<String, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> globalSrvDnsServiceDiscoverer() {
        return SrvClientInitializer.SRV_SD;
    }

    static <U, R> ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> mappingServiceDiscoverer(Function<U, R> toResolvedAddressMapper) {
        return new MappingServiceDiscoverer(toResolvedAddressMapper);
    }

    static final class MappingServiceDiscoverer<UnresolvedAddress, ResolvedAddress>
    implements ServiceDiscoverer<UnresolvedAddress, ResolvedAddress, ServiceDiscovererEvent<ResolvedAddress>> {
        private final Function<UnresolvedAddress, ResolvedAddress> toResolvedAddressMapper;
        private final ListenableAsyncCloseable closeable = AsyncCloseables.emptyAsyncCloseable();

        private MappingServiceDiscoverer(Function<UnresolvedAddress, ResolvedAddress> toResolvedAddressMapper) {
            this.toResolvedAddressMapper = Objects.requireNonNull(toResolvedAddressMapper);
        }

        @Override
        public Publisher<Collection<ServiceDiscovererEvent<ResolvedAddress>>> discover(UnresolvedAddress address) {
            return Publisher.from(Collections.singletonList(new DefaultServiceDiscovererEvent<ResolvedAddress>(Objects.requireNonNull(this.toResolvedAddressMapper.apply(address)), ServiceDiscovererEvent.Status.AVAILABLE))).concat(Publisher.never());
        }

        @Override
        public Completable onClose() {
            return this.closeable.onClose();
        }

        @Override
        public Completable closeAsync() {
            return this.closeable.closeAsync();
        }

        @Override
        public Completable closeAsyncGracefully() {
            return this.closeable.closeAsyncGracefully();
        }
    }

    private static final class SrvClientInitializer {
        static final ServiceDiscoverer<String, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> SRV_SD = new DefaultDnsServiceDiscovererBuilder().buildSrvDiscoverer();

        private SrvClientInitializer() {
        }

        static {
            LOGGER.debug("Initialized SrvClientInitializer");
        }
    }

    private static final class HostAndPortClientInitializer {
        static final ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> HOST_PORT_SD = new DefaultDnsServiceDiscovererBuilder().buildARecordDiscoverer();

        private HostAndPortClientInitializer() {
        }

        static {
            LOGGER.debug("Initialized HostAndPortClientInitializer");
        }
    }
}

