/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.netty.NettyH2HeadersToHttpHeaders;

public final class H2HeadersFactory
implements HttpHeadersFactory {
    private static final boolean DEFAULT_VALIDATE_VALUES = false;
    public static final HttpHeadersFactory INSTANCE = new H2HeadersFactory(true, true, false);
    private final boolean validateNames;
    private final boolean validateCookies;
    private final boolean validateValues;
    private final int headersArraySizeHint;
    private final int trailersArraySizeHint;

    public H2HeadersFactory(boolean validateNames, boolean validateCookies, boolean validateValues) {
        this(validateNames, validateCookies, validateValues, 16, 4);
    }

    public H2HeadersFactory(boolean validateNames, boolean validateCookies, boolean validateValues, int headersArraySizeHint, int trailersArraySizeHint) {
        this.validateNames = validateNames;
        this.validateCookies = validateCookies;
        this.validateValues = validateValues;
        this.headersArraySizeHint = headersArraySizeHint;
        this.trailersArraySizeHint = trailersArraySizeHint;
    }

    @Override
    public HttpHeaders newHeaders() {
        return new NettyH2HeadersToHttpHeaders(new DefaultHttp2Headers(this.validateNames, this.headersArraySizeHint), this.validateCookies, this.validateValues);
    }

    @Override
    public HttpHeaders newTrailers() {
        return new NettyH2HeadersToHttpHeaders(new DefaultHttp2Headers(this.validateNames, this.trailersArraySizeHint), this.validateCookies, this.validateValues);
    }

    @Override
    public HttpHeaders newEmptyTrailers() {
        return new NettyH2HeadersToHttpHeaders(new DefaultHttp2Headers(this.validateNames, 0), this.validateCookies, this.validateValues);
    }

    @Override
    public boolean validateCookies() {
        return this.validateCookies;
    }

    @Override
    public boolean validateValues() {
        return this.validateValues;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{validateNames=" + this.validateNames + ", validateCookies=" + this.validateCookies + ", validateValues=" + this.validateValues + ", headersArraySizeHint=" + this.headersArraySizeHint + ", trailersArraySizeHint=" + this.trailersArraySizeHint + '}';
    }
}

