/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.HttpExpectationFailedEvent;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.buffer.netty.BufferUtils;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpMetaData;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.netty.HeaderUtils;
import io.servicetalk.http.netty.HttpKeepAlive;
import io.servicetalk.transport.netty.internal.ByteToMessageDecoder;
import io.servicetalk.transport.netty.internal.CloseHandler;
import io.servicetalk.utils.internal.IllegalCharacterException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Nullable;

abstract class HttpObjectDecoder<T extends HttpMetaData>
extends ByteToMessageDecoder {
    private static final long HTTP_VERSION_FORMAT = 5211883372140375552L;
    private static final long HTTP_VERSION_MASK = -256L;
    private static final ByteProcessor SKIP_PREFACING_CRLF = value -> {
        if (HttpObjectDecoder.isVCHAR(value)) {
            return false;
        }
        if (value == 13 || value == 10) {
            return true;
        }
        throw new StacklessDecoderException("Invalid preface character before the start-line of the HTTP message", new IllegalCharacterException(value, "CR (0x0d), LF (0x0a)"));
    };
    private static final ByteProcessor FIND_WS = value -> !HttpObjectDecoder.isWS(value);
    private static final ByteProcessor FIND_VCHAR_END = value -> {
        if (HttpObjectDecoder.isVCHAR(value)) {
            return true;
        }
        if (HttpObjectDecoder.isWS(value)) {
            return false;
        }
        throw new IllegalCharacterException(value, "VCHAR (0x21-0x7e)");
    };
    private static final ByteProcessor FIND_COLON = value -> value != 58;
    private static final ByteProcessor FIND_FIELD_VALUE = value -> {
        if (HttpObjectDecoder.isWS(value)) {
            return true;
        }
        if (HttpObjectDecoder.isVCHAR(value) || HttpObjectDecoder.isObsText(value)) {
            return false;
        }
        throw new IllegalCharacterException(value, "HTAB / SP / VCHAR / obs-text");
    };
    private static final int MAX_HEX_CHARS_FOR_LONG = 16;
    private static final int CHUNK_DELIMETER_SIZE = 2;
    private static final int MAX_ALLOWED_CHARS_TO_SKIP = 4;
    private static final int MAX_ALLOWED_CHARS_TO_SKIP_PLUS_ONE = 5;
    private final int maxStartLineLength;
    private final int maxHeaderFieldLength;
    private final HttpHeadersFactory headersFactory;
    private final CloseHandler closeHandler;
    private final boolean allowPrematureClosureBeforePayloadBody;
    private final boolean allowLFWithoutCR;
    @Nullable
    private T message;
    @Nullable
    private HttpHeaders trailer;
    private long chunkSize;
    private int cumulationIndex = -1;
    private long contentLength = Long.MIN_VALUE;
    private int parsingLine;
    private State currentState = State.SKIP_CONTROL_CHARS;
    private int skippedControls;

    HttpObjectDecoder(ByteBufAllocator alloc, HttpHeadersFactory headersFactory, int maxStartLineLength, int maxHeaderFieldLength, boolean allowPrematureClosureBeforePayloadBody, boolean allowLFWithoutCR, CloseHandler closeHandler) {
        super(alloc);
        this.closeHandler = Objects.requireNonNull(closeHandler);
        if (maxStartLineLength <= 0) {
            throw new IllegalArgumentException("maxStartLineLength: " + maxStartLineLength + " (expected >0)");
        }
        if (maxHeaderFieldLength <= 0) {
            throw new IllegalArgumentException("maxHeaderFieldLength: " + maxHeaderFieldLength + " (expected >0)");
        }
        this.headersFactory = Objects.requireNonNull(headersFactory);
        this.maxStartLineLength = maxStartLineLength;
        this.maxHeaderFieldLength = maxHeaderFieldLength;
        this.allowPrematureClosureBeforePayloadBody = allowPrematureClosureBeforePayloadBody;
        this.allowLFWithoutCR = allowLFWithoutCR;
    }

    final HttpHeadersFactory headersFactory() {
        return this.headersFactory;
    }

    protected abstract boolean isDecodingRequest();

    protected abstract void handlePartialInitialLine(ChannelHandlerContext var1, ByteBuf var2);

    protected abstract T createMessage(ByteBuf var1, int var2, int var3, int var4, int var5, int var6, int var7);

    @Override
    protected final void decode(ChannelHandlerContext ctx, ByteBuf buffer) {
        switch (this.currentState) {
            case SKIP_CONTROL_CHARS: {
                if (!this.skipControlCharacters(buffer)) {
                    return;
                }
                this.currentState = State.READ_INITIAL;
            }
            case READ_INITIAL: {
                int bEnd;
                long longLFIndex = this.findCRLF(buffer, this.maxStartLineLength, this.allowLFWithoutCR);
                if (longLFIndex < 0L) {
                    this.handlePartialInitialLine(ctx, buffer);
                    return;
                }
                int lfIndex = HttpObjectDecoder.crlfIndex(longLFIndex);
                int nonControlIndex = HttpObjectDecoder.crlfBeforeIndex(longLFIndex);
                int aStart = buffer.readerIndex();
                int aEnd = buffer.forEachByte(aStart + 1, nonControlIndex - aStart, FIND_WS);
                if (aEnd < 0) {
                    throw this.newStartLineError("first");
                }
                int bStart = aEnd + 1;
                try {
                    bEnd = buffer.forEachByte(bStart, nonControlIndex - bStart + 1, this.isDecodingRequest() ? FIND_VCHAR_END : FIND_WS);
                }
                catch (IllegalCharacterException cause) {
                    throw new StacklessDecoderException("Invalid start-line: HTTP request-target contains an illegal character", cause);
                }
                if (bEnd < 0) {
                    if (this.isDecodingRequest()) {
                        throw this.newStartLineError("second");
                    }
                    bEnd = nonControlIndex + 1;
                }
                if (bEnd == bStart) {
                    throw new DecoderException("Invalid start-line: incorrect number of components, cannot find the " + (this.isDecodingRequest() ? "request-target" : "status-code") + ", expected: " + (this.isDecodingRequest() ? "method SP request-target SP HTTP-version" : "HTTP-version SP status-code SP reason-phrase"));
                }
                int cStart = bEnd + 1;
                int cLength = cStart > nonControlIndex ? 0 : nonControlIndex - cStart + 1;
                this.consumeCRLF(buffer, lfIndex);
                this.message = this.createMessage(buffer, aStart, aEnd - aStart, bStart, bEnd - bStart, cStart, cLength);
                this.currentState = State.READ_HEADER;
                if (!this.isInterim(this.message)) {
                    this.closeHandler.protocolPayloadBeginInbound(ctx);
                }
            }
            case READ_HEADER: {
                State nextState = this.readHeaders(buffer);
                if (nextState == null) {
                    return;
                }
                assert (this.message != null);
                if (HttpKeepAlive.shouldClose(this.message)) {
                    this.closeHandler.protocolClosingInbound(ctx);
                }
                this.onMetaDataRead(ctx, this.message);
                this.currentState = nextState;
                switch (nextState) {
                    case SKIP_CONTROL_CHARS: {
                        if (!this.isInterim(this.message)) {
                            ctx.fireChannelRead(this.message);
                            this.closeHandler.protocolPayloadEndInbound(ctx);
                        }
                        this.resetNow();
                        return;
                    }
                    case READ_CHUNK_SIZE: {
                        ctx.fireChannelRead(this.message);
                        return;
                    }
                }
                long contentLength = this.contentLength();
                if (contentLength == 0L || contentLength == -1L && this.isDecodingRequest()) {
                    ctx.fireChannelRead(this.message);
                    this.closeHandler.protocolPayloadEndInbound(ctx);
                    this.resetNow();
                    return;
                }
                assert (nextState == State.READ_FIXED_LENGTH_CONTENT || nextState == State.READ_VARIABLE_LENGTH_CONTENT);
                ctx.fireChannelRead(this.message);
                if (nextState == State.READ_FIXED_LENGTH_CONTENT) {
                    this.chunkSize = contentLength;
                }
                return;
            }
            case READ_VARIABLE_LENGTH_CONTENT: {
                int toRead = buffer.readableBytes();
                if (toRead > 0) {
                    this.onDataSeen();
                    ByteBuf content = buffer.readRetainedSlice(toRead);
                    this.cumulationIndex = buffer.readerIndex();
                    ctx.fireChannelRead(BufferUtils.newBufferFrom(content));
                }
                return;
            }
            case READ_FIXED_LENGTH_CONTENT: {
                int toRead = buffer.readableBytes();
                if (toRead == 0) {
                    return;
                }
                this.onDataSeen();
                if ((long)toRead > this.chunkSize) {
                    toRead = (int)this.chunkSize;
                }
                ByteBuf content = buffer.readRetainedSlice(toRead);
                this.chunkSize -= (long)toRead;
                this.cumulationIndex = buffer.readerIndex();
                if (this.chunkSize == 0L) {
                    ctx.fireChannelRead(BufferUtils.newBufferFrom(content));
                    this.closeHandler.protocolPayloadEndInbound(ctx);
                    this.resetNow();
                } else {
                    ctx.fireChannelRead(BufferUtils.newBufferFrom(content));
                }
                return;
            }
            case READ_CHUNK_SIZE: {
                long longLFIndex = this.findCRLF(buffer, 16, false);
                if (longLFIndex < 0L) {
                    return;
                }
                this.onDataSeen();
                int lfIndex = HttpObjectDecoder.crlfIndex(longLFIndex);
                long chunkSize = HttpObjectDecoder.getChunkSize(buffer, lfIndex);
                this.consumeCRLF(buffer, lfIndex);
                this.chunkSize = chunkSize;
                if (chunkSize == 0L) {
                    this.currentState = State.READ_CHUNK_FOOTER;
                    return;
                }
                this.currentState = State.READ_CHUNKED_CONTENT;
            }
            case READ_CHUNKED_CONTENT: {
                assert (this.chunkSize <= Integer.MAX_VALUE);
                int toRead = Math.min((int)this.chunkSize, buffer.readableBytes());
                if (toRead == 0) {
                    return;
                }
                this.onDataSeen();
                Buffer chunk = BufferUtils.newBufferFrom(buffer.readRetainedSlice(toRead));
                this.chunkSize -= (long)toRead;
                this.cumulationIndex = buffer.readerIndex();
                ctx.fireChannelRead(chunk);
                if (this.chunkSize != 0L) {
                    return;
                }
                this.currentState = State.READ_CHUNK_DELIMITER;
            }
            case READ_CHUNK_DELIMITER: {
                long longLFIndex = this.findCRLF(buffer, 2, false);
                if (longLFIndex < 0L) {
                    return;
                }
                this.consumeCRLF(buffer, HttpObjectDecoder.crlfIndex(longLFIndex));
                this.currentState = State.READ_CHUNK_SIZE;
                break;
            }
            case READ_CHUNK_FOOTER: {
                HttpHeaders trailer = this.readTrailingHeaders(buffer);
                if (trailer == null) {
                    return;
                }
                if (!trailer.isEmpty()) {
                    ctx.fireChannelRead(trailer);
                }
                this.closeHandler.protocolPayloadEndInbound(ctx);
                this.resetNow();
                return;
            }
            case UPGRADED: {
                int readableBytes = buffer.readableBytes();
                if (readableBytes <= 0) break;
                ByteBuf opaquePayload = buffer.readBytes(readableBytes);
                this.cumulationIndex = buffer.readerIndex();
                ctx.fireChannelRead(opaquePayload);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    @Override
    protected final ByteBuf swapAndCopyCumulation(ByteBuf cumulation, ByteBuf in) {
        int readerIndex = cumulation.readerIndex();
        ByteBuf newCumulation = super.swapAndCopyCumulation(cumulation, in);
        this.cumulationIndex -= readerIndex - newCumulation.readerIndex();
        return newCumulation;
    }

    @Override
    protected final void cumulationReset() {
        this.cumulationIndex = -1;
    }

    @Override
    protected final void decodeLast(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        super.decodeLast(ctx, in);
        if (this.message != null) {
            boolean prematureClosure;
            boolean chunked = io.servicetalk.http.api.HeaderUtils.isTransferEncodingChunked(this.message.headers());
            if (!in.isReadable() && (this.currentState == State.READ_VARIABLE_LENGTH_CONTENT && !chunked || this.currentState == State.READ_CHUNK_SIZE && chunked && this.allowPrematureClosureBeforePayloadBody)) {
                this.closeHandler.protocolPayloadEndInbound(ctx);
                this.resetNow();
                return;
            }
            if (this.currentState == State.READ_HEADER) {
                ctx.fireExceptionCaught(new PrematureChannelClosureException("Connection closed before received headers"));
                this.resetNow();
                return;
            }
            if (this.isDecodingRequest() || chunked) {
                prematureClosure = true;
            } else {
                boolean bl = prematureClosure = this.contentLength() > 0L;
            }
            if (!prematureClosure) {
                this.closeHandler.protocolPayloadEndInbound(ctx);
            }
            this.resetNow();
        }
    }

    @Override
    public final void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof HttpExpectationFailedEvent) {
            switch (this.currentState) {
                case READ_CHUNK_SIZE: 
                case READ_VARIABLE_LENGTH_CONTENT: 
                case READ_FIXED_LENGTH_CONTENT: {
                    this.resetNow();
                    break;
                }
            }
        } else if (evt instanceof CloseHandler.DiscardFurtherInboundEvent) {
            this.resetNow();
            ctx.pipeline().replace(this, DiscardInboundHandler.INSTANCE.toString(), (ChannelHandler)DiscardInboundHandler.INSTANCE);
            ctx.channel().config().setAutoRead(true);
        }
        super.userEventTriggered(ctx, evt);
    }

    protected abstract boolean isContentAlwaysEmpty(T var1);

    protected abstract boolean isInterim(T var1);

    protected abstract void onMetaDataRead(ChannelHandlerContext var1, T var2);

    protected abstract void onDataSeen();

    private static boolean isSwitchingToNonHttp1Protocol(HttpResponseMetaData msg) {
        if (msg.status().code() != HttpResponseStatus.SWITCHING_PROTOCOLS.code()) {
            return false;
        }
        CharSequence newProtocol = msg.headers().get(HttpHeaderNames.UPGRADE);
        return newProtocol == null || !AsciiString.contains(newProtocol, HttpProtocolVersion.HTTP_1_0.toString()) && !AsciiString.contains(newProtocol, HttpProtocolVersion.HTTP_1_1.toString());
    }

    protected void resetNow() {
        HttpResponseMetaData res;
        T message = this.message;
        this.message = null;
        this.trailer = null;
        this.contentLength = Long.MIN_VALUE;
        this.parsingLine = 0;
        this.cumulationIndex = -1;
        if (!this.isDecodingRequest() && (res = (HttpResponseMetaData)message) != null && HttpObjectDecoder.isSwitchingToNonHttp1Protocol(res)) {
            this.currentState = State.UPGRADED;
            return;
        }
        this.currentState = State.SKIP_CONTROL_CHARS;
        this.skippedControls = 0;
    }

    private boolean skipControlCharacters(ByteBuf buffer) {
        int readableBytes;
        int len;
        int i;
        if (this.cumulationIndex < 0) {
            this.cumulationIndex = buffer.readerIndex();
        }
        if ((i = buffer.forEachByte(this.cumulationIndex, len = Math.min(5 - this.skippedControls, readableBytes = buffer.writerIndex() - this.cumulationIndex), SKIP_PREFACING_CRLF)) < 0) {
            this.skippedControls += len;
            if (this.skippedControls > 4) {
                throw new DecoderException("Too many prefacing CRLF (0x0d0a) characters before the start-line of the HTTP message");
            }
            this.cumulationIndex += len;
            buffer.readerIndex(this.cumulationIndex);
            return false;
        }
        this.cumulationIndex = i;
        buffer.readerIndex(i);
        return true;
    }

    private void parseHeaderLine(HttpHeaders headers, ByteBuf buffer, int lfIndex, int nonControlIndex) throws DecoderException {
        CharSequence value;
        int nameStart = buffer.readerIndex();
        int nameEnd = buffer.forEachByte(nameStart, nonControlIndex - nameStart + 1, FIND_COLON);
        if (nameEnd < 0) {
            throw HttpObjectDecoder.newDecoderExceptionAtLine("Unable to find end of a header name in line ", this.parsingLine);
        }
        if (nameEnd == nameStart) {
            throw HttpObjectDecoder.newDecoderExceptionAtLine("Empty header name in line ", this.parsingLine);
        }
        CharSequence name = CharSequences.newAsciiString(BufferUtils.newBufferFrom(buffer.retainedSlice(nameStart, nameEnd - nameStart)));
        try {
            int valueStart;
            if (nameEnd >= nonControlIndex || (valueStart = buffer.forEachByte(nameEnd + 1, nonControlIndex - nameEnd, FIND_FIELD_VALUE)) < 0) {
                value = CharSequences.emptyAsciiString();
            } else {
                int valueEnd = buffer.forEachByteDesc(valueStart, nonControlIndex - valueStart + 1, FIND_FIELD_VALUE);
                value = CharSequences.newAsciiString(BufferUtils.newBufferFrom(buffer.retainedSlice(valueStart, valueEnd - valueStart + 1)));
            }
        }
        catch (IllegalCharacterException cause) {
            throw HttpObjectDecoder.invalidHeaderValue(name, this.parsingLine, cause);
        }
        try {
            headers.add(name, value);
        }
        catch (IllegalCharacterException cause) {
            throw HttpObjectDecoder.invalidHeaderName(name, this.parsingLine, cause);
        }
        this.consumeCRLF(buffer, lfIndex);
    }

    private static DecoderException newDecoderExceptionAtLine(String message, int parsingLine) {
        return new DecoderException(message + (parsingLine - 1));
    }

    private static DecoderException invalidHeaderName(CharSequence name, int parsingLine, IllegalCharacterException cause) {
        throw new StacklessDecoderException("Invalid header name in line " + (parsingLine - 1) + ": " + name, cause);
    }

    private static DecoderException invalidHeaderValue(CharSequence name, int parsingLine, IllegalCharacterException cause) {
        throw new StacklessDecoderException("Invalid value for the header '" + name + "' in line " + (parsingLine - 1), cause);
    }

    @Nullable
    private State readHeaders(ByteBuf buffer) {
        long longLFIndex = this.findCRLF(buffer, this.maxHeaderFieldLength, this.allowLFWithoutCR);
        if (longLFIndex < 0L) {
            return null;
        }
        T message = this.message;
        assert (message != null);
        if (!this.parseAllHeaders(buffer, message.headers(), longLFIndex)) {
            return null;
        }
        long contentLength = this.contentLength();
        if (this.isContentAlwaysEmpty(message)) {
            HeaderUtils.removeTransferEncodingChunked(message.headers());
            return State.SKIP_CONTROL_CHARS;
        }
        if (io.servicetalk.http.api.HeaderUtils.isTransferEncodingChunked(message.headers())) {
            if (contentLength >= 0L && HttpProtocolVersion.HTTP_1_1.equals(message.version())) {
                message.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
                this.contentLength = Long.MIN_VALUE;
            }
            return State.READ_CHUNK_SIZE;
        }
        if (contentLength >= 0L) {
            return State.READ_FIXED_LENGTH_CONTENT;
        }
        return State.READ_VARIABLE_LENGTH_CONTENT;
    }

    private long contentLength() {
        if (this.contentLength == Long.MIN_VALUE) {
            assert (this.message != null);
            this.contentLength = HttpObjectDecoder.getContentLength(this.message);
        }
        return this.contentLength;
    }

    @Nullable
    private HttpHeaders readTrailingHeaders(ByteBuf buffer) {
        long longLFIndex = this.findCRLF(buffer, this.maxHeaderFieldLength, this.allowLFWithoutCR);
        if (longLFIndex < 0L) {
            return null;
        }
        if (HttpObjectDecoder.crlfBeforeIndex(longLFIndex) > buffer.readerIndex()) {
            HttpHeaders trailer = this.trailer;
            if (trailer == null) {
                trailer = this.trailer = this.headersFactory.newTrailers();
            }
            return this.parseAllHeaders(buffer, trailer, longLFIndex) ? trailer : null;
        }
        this.consumeCRLF(buffer, HttpObjectDecoder.crlfIndex(longLFIndex));
        return this.trailer != null ? this.trailer : this.headersFactory.newEmptyTrailers();
    }

    private boolean parseAllHeaders(ByteBuf buffer, HttpHeaders headers, long longLFIndex) {
        while (true) {
            int lfIndex = HttpObjectDecoder.crlfIndex(longLFIndex);
            int nonControlIndex = HttpObjectDecoder.crlfBeforeIndex(longLFIndex);
            if (nonControlIndex < buffer.readerIndex()) {
                this.consumeCRLF(buffer, lfIndex);
                return true;
            }
            longLFIndex = HttpObjectDecoder.findCRLF(buffer, lfIndex + 1, this.maxHeaderFieldLength, this.parsingLine, this.allowLFWithoutCR);
            this.parseHeaderLine(headers, buffer, lfIndex, nonControlIndex);
            if (longLFIndex < 0L) {
                return false;
            }
            ++this.parsingLine;
        }
    }

    private static long getChunkSize(ByteBuf buffer, int lfIndex) {
        if (lfIndex - 2 < buffer.readerIndex()) {
            throw new DecoderException("Chunked encoding specified but chunk-size not found");
        }
        return HttpObjectDecoder.getChunkSize(buffer.toString(buffer.readerIndex(), lfIndex - 1 - buffer.readerIndex(), StandardCharsets.US_ASCII));
    }

    private static long getChunkSize(String hex) {
        hex = hex.trim();
        for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            if (c != ';' && !Character.isWhitespace(c) && !Character.isISOControl(c)) continue;
            hex = hex.substring(0, i);
            break;
        }
        try {
            return Long.parseUnsignedLong(hex, 16);
        }
        catch (NumberFormatException cause) {
            throw HttpObjectDecoder.invalidChunkSize(hex, cause);
        }
    }

    private static DecoderException invalidChunkSize(String hex, NumberFormatException cause) {
        return new StacklessDecoderException("Cannot parse chunk-size: " + hex + ", expected a valid HEXDIG", cause);
    }

    private void consumeCRLF(ByteBuf buffer, int lfIndex) {
        if (buffer.writerIndex() - 1 >= lfIndex) {
            buffer.readerIndex(lfIndex + 1);
            this.cumulationIndex = lfIndex + 1;
        } else {
            buffer.readerIndex(lfIndex);
            this.cumulationIndex = lfIndex;
        }
    }

    private long findCRLF(ByteBuf buffer, int maxLineSize, boolean allowLFWithoutCR) {
        long longLFIndex;
        if (this.cumulationIndex < 0) {
            this.cumulationIndex = buffer.readerIndex();
        }
        if ((longLFIndex = HttpObjectDecoder.findCRLF(buffer, this.cumulationIndex, maxLineSize, this.parsingLine, allowLFWithoutCR)) < 0L) {
            this.cumulationIndex = Math.min(buffer.writerIndex(), this.cumulationIndex + maxLineSize);
        } else {
            this.cumulationIndex = HttpObjectDecoder.crlfIndex(longLFIndex);
            ++this.parsingLine;
        }
        return longLFIndex;
    }

    private static long findCRLF(ByteBuf buffer, int startIndex, int maxLineSize, int parsingLine, boolean allowLFWithoutCR) {
        int lfIndex;
        int maxToIndex = FlowControlUtils.addWithOverflowProtection(startIndex, maxLineSize);
        while (true) {
            int toIndex;
            if ((lfIndex = HttpObjectDecoder.findLF(buffer, startIndex, toIndex = Math.min(buffer.writerIndex(), maxToIndex))) == -1) {
                if (toIndex - startIndex == maxLineSize) {
                    throw new DecoderException("Could not find CRLF (0x0d0a) within " + maxLineSize + " bytes, while parsing line " + parsingLine);
                }
                return -2L;
            }
            if (lfIndex != buffer.readerIndex()) break;
            if (allowLFWithoutCR) {
                return (long)lfIndex << 32 | (long)lfIndex;
            }
            buffer.skipBytes(1);
            ++startIndex;
        }
        boolean foundCR = buffer.getByte(lfIndex - 1) == 13;
        if (foundCR || allowLFWithoutCR) {
            return foundCR ? (long)lfIndex - 1L << 32 | (long)lfIndex : (long)lfIndex << 32 | (long)lfIndex;
        }
        if (lfIndex != maxToIndex) {
            throw new DecoderException("Found LF (0x0a) but no CR (0x0d) before, while parsing line " + parsingLine);
        }
        throw new TooLongFrameException("An HTTP line " + parsingLine + " is larger than " + maxLineSize + " bytes");
    }

    private static int crlfIndex(long index) {
        return (int)index;
    }

    private static int crlfBeforeIndex(long index) {
        return (int)(index >>> 32) - 1;
    }

    private static int findLF(ByteBuf buffer, int fromIndex, int toIndex) {
        if (fromIndex >= toIndex) {
            return -1;
        }
        return buffer.forEachByte(fromIndex, toIndex - fromIndex, ByteProcessor.FIND_LF);
    }

    private DecoderException newStartLineError(String place) {
        return new DecoderException("Invalid start-line: incorrect number of components, cannot find the " + place + " SP, expected: " + (this.isDecodingRequest() ? "method SP request-target SP HTTP-version" : "HTTP-version SP status-code SP reason-phrase"));
    }

    private static int getWebSocketContentLength(HttpMetaData message) {
        HttpResponseMetaData res;
        HttpHeaders h = message.headers();
        if (message instanceof HttpRequestMetaData) {
            HttpRequestMetaData req = (HttpRequestMetaData)message;
            if (HttpRequestMethod.GET.equals(req.method()) && h.contains(HttpHeaderNames.SEC_WEBSOCKET_KEY1) && h.contains(HttpHeaderNames.SEC_WEBSOCKET_KEY2)) {
                return 8;
            }
        } else if (message instanceof HttpResponseMetaData && (res = (HttpResponseMetaData)message).status().code() == HttpResponseStatus.SWITCHING_PROTOCOLS.code() && h.contains(HttpHeaderNames.SEC_WEBSOCKET_ORIGIN) && h.contains(HttpHeaderNames.SEC_WEBSOCKET_LOCATION)) {
            return 16;
        }
        return -1;
    }

    static long getContentLength(HttpMetaData message) {
        HttpHeaders headers = message.headers();
        long contentLength = HeaderUtils.contentLength(headers.valuesIterator(HttpHeaderNames.CONTENT_LENGTH));
        if (contentLength >= 0L) {
            return contentLength;
        }
        long webSocketContentLength = HttpObjectDecoder.getWebSocketContentLength(message);
        if (webSocketContentLength >= 0L) {
            return webSocketContentLength;
        }
        return -1L;
    }

    static HttpProtocolVersion nettyBufferToHttpVersion(ByteBuf buffer, int start, int length) {
        if (length != 8) {
            throw HttpObjectDecoder.newHttpVersionError(buffer, start, length, null);
        }
        long httpVersion = buffer.getLong(start);
        if ((httpVersion & 0xFFFFFFFFFFFFFF00L) != 5211883372140375552L) {
            throw HttpObjectDecoder.newHttpVersionError(buffer, start, length, null);
        }
        try {
            return HttpProtocolVersion.of(1, HttpObjectDecoder.toDecimal((int)httpVersion & 0xFF));
        }
        catch (IllegalCharacterException cause) {
            throw HttpObjectDecoder.newHttpVersionError(buffer, start, length, cause);
        }
    }

    private static DecoderException newHttpVersionError(ByteBuf buffer, int start, int length, @Nullable Throwable cause) {
        String message = "Invalid HTTP version: '" + buffer.toString(start, length, StandardCharsets.US_ASCII) + "', expected: HTTP/1.x";
        return cause == null ? new DecoderException(message) : new StacklessDecoderException(message, cause);
    }

    static int toDecimal(int value) {
        if (value < 48 || value > 57) {
            throw new IllegalCharacterException((byte)value, "0-9 (0x30-0x39)");
        }
        return value - 48;
    }

    static boolean isWS(byte value) {
        return value == 32 || value == 9;
    }

    static boolean isVCHAR(byte value) {
        return value >= 33 && value <= 126;
    }

    private static boolean isObsText(byte value) {
        return value < 0;
    }

    static final class StacklessDecoderException
    extends DecoderException {
        private static final long serialVersionUID = 7611225180490304156L;

        StacklessDecoderException(String message, Throwable cause) {
            super(message, cause);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    @ChannelHandler.Sharable
    private static final class DiscardInboundHandler
    extends SimpleChannelInboundHandler<Object> {
        static final ChannelInboundHandler INSTANCE = new DiscardInboundHandler();

        private DiscardInboundHandler() {
            super(true);
        }

        @Override
        protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        }
    }

    private static enum State {
        SKIP_CONTROL_CHARS,
        READ_INITIAL,
        READ_HEADER,
        READ_VARIABLE_LENGTH_CONTENT,
        READ_FIXED_LENGTH_CONTENT,
        READ_CHUNK_SIZE,
        READ_CHUNKED_CONTENT,
        READ_CHUNK_DELIMITER,
        READ_CHUNK_FOOTER,
        UPGRADED;

    }
}

