/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.SingleOperator;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.api.TerminalSignalConsumer;
import io.servicetalk.concurrent.internal.CancelImmediatelySubscriber;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.utils.internal.ThrowableUtils;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nullable;

public final class BeforeFinallyHttpOperator
implements SingleOperator<StreamingHttpResponse, StreamingHttpResponse> {
    private final TerminalSignalConsumer beforeFinally;
    private final boolean discardEventsAfterCancel;

    public BeforeFinallyHttpOperator(TerminalSignalConsumer beforeFinally) {
        this(beforeFinally, false);
    }

    public BeforeFinallyHttpOperator(Runnable beforeFinally) {
        this(TerminalSignalConsumer.from(beforeFinally));
    }

    public BeforeFinallyHttpOperator(TerminalSignalConsumer beforeFinally, boolean discardEventsAfterCancel) {
        this.beforeFinally = Objects.requireNonNull(beforeFinally);
        this.discardEventsAfterCancel = discardEventsAfterCancel;
    }

    @Override
    public SingleSource.Subscriber<? super StreamingHttpResponse> apply(SingleSource.Subscriber<? super StreamingHttpResponse> subscriber) {
        return new ResponseCompletionSubscriber(subscriber, this.beforeFinally, this.discardEventsAfterCancel);
    }

    private static final class ResponseCompletionSubscriber
    implements SingleSource.Subscriber<StreamingHttpResponse> {
        private static final int IDLE = 0;
        private static final int PROCESSING_PAYLOAD = 1;
        private static final int DELIVERING_PAYLOAD = 2;
        private static final int AWAITING_CANCEL = 3;
        private static final int TERMINATED = 4;
        private static final AtomicIntegerFieldUpdater<ResponseCompletionSubscriber> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(ResponseCompletionSubscriber.class, "state");
        private final SingleSource.Subscriber<? super StreamingHttpResponse> subscriber;
        private final TerminalSignalConsumer beforeFinally;
        private final boolean discardEventsAfterCancel;
        private volatile int state;

        ResponseCompletionSubscriber(SingleSource.Subscriber<? super StreamingHttpResponse> sub, TerminalSignalConsumer beforeFinally, boolean discardEventsAfterCancel) {
            this.subscriber = sub;
            this.beforeFinally = beforeFinally;
            this.discardEventsAfterCancel = discardEventsAfterCancel;
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
            this.subscriber.onSubscribe(() -> {
                try {
                    if (stateUpdater.compareAndSet(this, 0, 4)) {
                        this.beforeFinally.cancel();
                    }
                }
                finally {
                    cancellable.cancel();
                }
            });
        }

        @Override
        public void onSuccess(@Nullable StreamingHttpResponse response) {
            if (response == null) {
                this.sendNullResponse();
            } else if (stateUpdater.compareAndSet(this, 0, 1)) {
                this.subscriber.onSuccess(response.transformMessageBody(payload -> payload.liftSync(subscriber -> new PublisherSource.Subscriber<Object>(){
                    @Nullable
                    private PublisherSource.Subscription subscription;

                    @Override
                    public void onSubscribe(final PublisherSource.Subscription subscription) {
                        this.subscription = subscription;
                        subscriber.onSubscribe(new PublisherSource.Subscription(){

                            @Override
                            public void request(long n) {
                                subscription.request(n);
                            }

                            @Override
                            public void cancel() {
                                block15: {
                                    int state;
                                    block16: {
                                        if (!discardEventsAfterCancel) {
                                            try {
                                                if (stateUpdater.compareAndSet(this, 1, 4)) {
                                                    beforeFinally.cancel();
                                                }
                                            }
                                            finally {
                                                subscription.cancel();
                                            }
                                            return;
                                        }
                                        while (true) {
                                            state = state;
                                            assert (state != 0);
                                            if (state == 1) {
                                                if (!stateUpdater.compareAndSet(this, 1, 4)) continue;
                                                try {
                                                    beforeFinally.cancel();
                                                    break block15;
                                                }
                                                finally {
                                                    subscription.cancel();
                                                }
                                            }
                                            if (state != 2) break block16;
                                            if (stateUpdater.compareAndSet(this, 2, 3)) break;
                                        }
                                        break block15;
                                    }
                                    if (state == 4) {
                                        subscription.cancel();
                                    } else assert (state == 3);
                                }
                            }
                        });
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onNext(@Nullable Object o) {
                        int state;
                        if (!discardEventsAfterCancel) {
                            subscriber.onNext(o);
                            return;
                        }
                        boolean reentry = false;
                        do {
                            state = state;
                            assert (state != 0);
                            if (state == 4) {
                                return;
                            }
                            if (state != 2 && state != 3) continue;
                            reentry = true;
                            break;
                        } while (!stateUpdater.compareAndSet(this, 1, 2));
                        try {
                            subscriber.onNext(o);
                        }
                        finally {
                            block19: {
                                if (!reentry) {
                                    while (true) {
                                        state = state;
                                        assert (state != 0);
                                        assert (state != 1);
                                        if (state == 4) break block19;
                                        if (state == 2) {
                                            if (!stateUpdater.compareAndSet(this, 2, 1)) continue;
                                            break block19;
                                        }
                                        if (stateUpdater.compareAndSet(this, 3, 4)) break;
                                    }
                                    try {
                                        beforeFinally.cancel();
                                    }
                                    finally {
                                        assert (this.subscription != null);
                                        this.subscription.cancel();
                                    }
                                }
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onError(Throwable t) {
                        if (!discardEventsAfterCancel) {
                            try {
                                if (stateUpdater.compareAndSet(this, 1, 4)) {
                                    beforeFinally.onError(t);
                                }
                            }
                            catch (Throwable cause) {
                                ThrowableUtils.addSuppressed(t, cause);
                            }
                            subscriber.onError(t);
                            return;
                        }
                        int prevState = this.setTerminalState();
                        if (prevState == 4) {
                            return;
                        }
                        boolean propagateCancel = prevState == 3;
                        try {
                            beforeFinally.onError(t);
                        }
                        catch (Throwable cause) {
                            ThrowableUtils.addSuppressed(t, cause);
                        }
                        try {
                            subscriber.onError(t);
                        }
                        finally {
                            this.cancel0(propagateCancel);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onComplete() {
                        if (!discardEventsAfterCancel) {
                            try {
                                if (stateUpdater.compareAndSet(this, 1, 4)) {
                                    beforeFinally.onComplete();
                                }
                            }
                            catch (Throwable cause) {
                                subscriber.onError(cause);
                                return;
                            }
                            subscriber.onComplete();
                            return;
                        }
                        int prevState = this.setTerminalState();
                        if (prevState == 4) {
                            return;
                        }
                        boolean propagateCancel = prevState == 3;
                        try {
                            try {
                                beforeFinally.onComplete();
                            }
                            catch (Throwable cause) {
                                subscriber.onError(cause);
                                this.cancel0(propagateCancel);
                                return;
                            }
                            subscriber.onComplete();
                        }
                        finally {
                            this.cancel0(propagateCancel);
                        }
                    }

                    private int setTerminalState() {
                        int state;
                        do {
                            state = state;
                            assert (state != 0);
                            if (state != 4) continue;
                            return state;
                        } while (!(state == 1 ? stateUpdater.compareAndSet(this, 1, 4) : stateUpdater.compareAndSet(this, state, 4)));
                        return state;
                    }

                    private void cancel0(boolean propagateCancel) {
                        if (propagateCancel) {
                            assert (this.subscription != null);
                            this.subscription.cancel();
                        }
                    }
                })));
            } else {
                assert (this.state == 4);
                if (this.discardEventsAfterCancel) {
                    return;
                }
                this.subscriber.onSuccess(response.transformMessageBody(payload -> {
                    SourceAdapters.toSource(payload).subscribe(CancelImmediatelySubscriber.INSTANCE);
                    return Publisher.failed(new CancellationException("Received response post cancel."));
                }));
            }
        }

        @Override
        public void onError(Throwable t) {
            try {
                if (stateUpdater.compareAndSet(this, 0, 4)) {
                    this.beforeFinally.onError(t);
                } else if (this.discardEventsAfterCancel) {
                    return;
                }
            }
            catch (Throwable cause) {
                ThrowableUtils.addSuppressed(t, cause);
            }
            this.subscriber.onError(t);
        }

        private void sendNullResponse() {
            try {
                if (stateUpdater.compareAndSet(this, 0, 4)) {
                    this.beforeFinally.onComplete();
                } else if (this.discardEventsAfterCancel) {
                    return;
                }
            }
            catch (Throwable cause) {
                this.subscriber.onError(cause);
                return;
            }
            this.subscriber.onSuccess(null);
        }
    }
}

