/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.client.api;

import io.servicetalk.client.api.ConnectionFactory;
import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.client.api.DelegatingConnectionFactory;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.api.TransportObservers;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class TransportObserverConnectionFactoryFilter<ResolvedAddress, C extends ListenableAsyncCloseable>
implements ConnectionFactoryFilter<ResolvedAddress, C> {
    private final Function<ResolvedAddress, TransportObserver> observerFactory;

    public TransportObserverConnectionFactoryFilter(TransportObserver observer) {
        Objects.requireNonNull(observer);
        this.observerFactory = __ -> observer;
    }

    public TransportObserverConnectionFactoryFilter(Function<ResolvedAddress, TransportObserver> observerFactory) {
        this.observerFactory = Objects.requireNonNull(observerFactory);
    }

    @Override
    public ConnectionFactory<ResolvedAddress, C> create(ConnectionFactory<ResolvedAddress, C> original) {
        return new DelegatingConnectionFactory<ResolvedAddress, C>(original){

            @Override
            public Single<C> newConnection(ResolvedAddress resolvedAddress, @Nullable TransportObserver originalObserver) {
                TransportObserver newObserver;
                try {
                    newObserver = (TransportObserver)TransportObserverConnectionFactoryFilter.this.observerFactory.apply(resolvedAddress);
                }
                catch (Throwable t) {
                    return Single.failed(t);
                }
                return this.delegate().newConnection(resolvedAddress, originalObserver == null ? newObserver : (newObserver == null ? originalObserver : TransportObservers.combine(originalObserver, newObserver)));
            }
        };
    }

    @Override
    public ExecutionStrategy requiredOffloads() {
        return ExecutionStrategy.offloadNone();
    }
}

