/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractSynchronousCompletableOperator;
import io.servicetalk.concurrent.api.Completable;
import java.util.Objects;
import java.util.function.Supplier;

final class AfterSubscriberCompletable
extends AbstractSynchronousCompletableOperator {
    private final Supplier<? extends CompletableSource.Subscriber> subscriberSupplier;

    AfterSubscriberCompletable(Completable original, Supplier<? extends CompletableSource.Subscriber> subscriberSupplier) {
        super(original);
        this.subscriberSupplier = Objects.requireNonNull(subscriberSupplier);
    }

    @Override
    public CompletableSource.Subscriber apply(CompletableSource.Subscriber subscriber) {
        return new AfterSubscriberCompletableSubscriber(subscriber, this.subscriberSupplier.get());
    }

    private static final class AfterSubscriberCompletableSubscriber
    implements CompletableSource.Subscriber {
        private final CompletableSource.Subscriber original;
        private final CompletableSource.Subscriber subscriber;

        AfterSubscriberCompletableSubscriber(CompletableSource.Subscriber original, CompletableSource.Subscriber subscriber) {
            this.original = original;
            this.subscriber = Objects.requireNonNull(subscriber);
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
            this.original.onSubscribe(cancellable);
            this.subscriber.onSubscribe(cancellable);
        }

        @Override
        public void onComplete() {
            this.original.onComplete();
            this.subscriber.onComplete();
        }

        @Override
        public void onError(Throwable t) {
            this.original.onError(t);
            this.subscriber.onError(t);
        }
    }
}

