/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.ContextPreservingCancellable;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;
import javax.annotation.Nullable;

final class ContextPreservingCancellableSingleSubscriber<T>
implements SingleSource.Subscriber<T> {
    final ContextMap saved;
    final SingleSource.Subscriber<T> subscriber;

    ContextPreservingCancellableSingleSubscriber(SingleSource.Subscriber<T> subscriber, ContextMap current) {
        this.subscriber = Objects.requireNonNull(subscriber);
        this.saved = Objects.requireNonNull(current);
    }

    @Override
    public void onSubscribe(Cancellable cancellable) {
        this.subscriber.onSubscribe(ContextPreservingCancellable.wrap(cancellable, this.saved));
    }

    @Override
    public void onSuccess(@Nullable T result) {
        this.subscriber.onSuccess(result);
    }

    @Override
    public void onError(Throwable t) {
        this.subscriber.onError(t);
    }

    public String toString() {
        return ContextPreservingCancellableSingleSubscriber.class.getSimpleName() + '(' + this.subscriber + ')';
    }
}

