/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AbstractProcessorBuffer;
import io.servicetalk.concurrent.api.BlockingProcessorSignalsHolder;
import io.servicetalk.concurrent.api.ProcessorSignalsConsumer;
import io.servicetalk.concurrent.api.SubscriberApiUtils;
import io.servicetalk.concurrent.internal.TerminalNotification;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

final class DefaultBlockingProcessorSignalsHolder<T>
extends AbstractProcessorBuffer
implements BlockingProcessorSignalsHolder<T> {
    private final BlockingQueue<Object> signals;

    DefaultBlockingProcessorSignalsHolder(int maxBuffer) {
        this.signals = new LinkedBlockingQueue<Object>(maxBuffer);
    }

    @Override
    public void add(@Nullable T item) throws InterruptedException {
        this.signals.put(SubscriberApiUtils.wrapNull(item));
    }

    @Override
    public void terminate() throws InterruptedException {
        TerminalNotification terminal = TerminalNotification.complete();
        if (this.tryTerminate(terminal)) {
            this.signals.put(terminal);
        }
    }

    @Override
    public void terminate(Throwable cause) throws InterruptedException {
        TerminalNotification terminal = TerminalNotification.error(cause);
        if (this.tryTerminate(terminal)) {
            this.signals.put(terminal);
        }
    }

    @Override
    public boolean consume(ProcessorSignalsConsumer<T> consumer) throws InterruptedException {
        Object signal = this.signals.take();
        return DefaultBlockingProcessorSignalsHolder.consumeIfTerminal(consumer, signal) || DefaultBlockingProcessorSignalsHolder.consumeNextItem(consumer, signal);
    }

    @Override
    public boolean consume(ProcessorSignalsConsumer<T> consumer, long waitFor, TimeUnit waitForUnit) throws TimeoutException, InterruptedException {
        Object signal = this.signals.poll(waitFor, waitForUnit);
        if (signal == null) {
            throw new TimeoutException("Timed out after " + waitFor + "(" + (Object)((Object)waitForUnit) + ") waiting for an item.");
        }
        return DefaultBlockingProcessorSignalsHolder.consumeIfTerminal(consumer, signal) || DefaultBlockingProcessorSignalsHolder.consumeNextItem(consumer, signal);
    }
}

