/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Publisher;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class OnErrorMapPublisher<T>
extends AbstractSynchronousPublisherOperator<T, T> {
    private final Predicate<? super Throwable> predicate;
    private final Function<? super Throwable, ? extends Throwable> mapper;

    OnErrorMapPublisher(Publisher<T> original, Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends Throwable> mapper) {
        super(original);
        this.predicate = Objects.requireNonNull(predicate);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super T> subscriber) {
        return new ErrorMapSubscriber(subscriber);
    }

    private final class ErrorMapSubscriber
    implements PublisherSource.Subscriber<T> {
        private final PublisherSource.Subscriber<? super T> subscriber;

        private ErrorMapSubscriber(PublisherSource.Subscriber<? super T> subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription subscription) {
            this.subscriber.onSubscribe(subscription);
        }

        @Override
        public void onNext(@Nullable T t) {
            this.subscriber.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            boolean predicateResult;
            try {
                predicateResult = OnErrorMapPublisher.this.predicate.test(t);
            }
            catch (Throwable cause) {
                this.subscriber.onError(cause);
                return;
            }
            if (predicateResult) {
                Throwable mappedCause;
                try {
                    mappedCause = (Throwable)Objects.requireNonNull(OnErrorMapPublisher.this.mapper.apply(t));
                }
                catch (Throwable cause) {
                    this.subscriber.onError(cause);
                    return;
                }
                this.subscriber.onError(mappedCause);
            } else {
                this.subscriber.onError(t);
            }
        }

        @Override
        public void onComplete() {
            this.subscriber.onComplete();
        }
    }
}

