/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Objects;
import java.util.function.Supplier;

final class PublisherDefer<T>
extends Publisher<T>
implements PublisherSource<T> {
    private final Supplier<? extends Publisher<? extends T>> publisherFactory;

    PublisherDefer(Supplier<? extends Publisher<? extends T>> publisherFactory) {
        this.publisherFactory = Objects.requireNonNull(publisherFactory);
    }

    @Override
    protected void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber) {
        Publisher<? super T> publisher;
        try {
            publisher = Objects.requireNonNull(this.publisherFactory.get());
        }
        catch (Throwable cause) {
            SubscriberUtils.deliverErrorFromSource(subscriber, cause);
            return;
        }
        publisher.subscribeInternal(subscriber);
    }

    @Override
    public void subscribe(PublisherSource.Subscriber<? super T> subscriber) {
        this.subscribeInternal(subscriber);
    }
}

