/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.concurrent.internal.ThrowableUtils;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import javax.annotation.Nullable;

final class RepeatWhenSingle<T>
extends AbstractNoHandleSubscribePublisher<T> {
    private static final Exception END_REPEAT_EXCEPTION = ThrowableUtils.unknownStackTrace(new Exception(), RepeatWhenSingle.class, "<init>");
    static final Completable END_REPEAT_COMPLETABLE = Completable.failed(END_REPEAT_EXCEPTION);
    private final Single<T> original;
    private final BiIntFunction<? super T, ? extends Completable> repeater;

    RepeatWhenSingle(Single<T> original, BiIntFunction<? super T, ? extends Completable> repeater) {
        this.original = original;
        this.repeater = Objects.requireNonNull(repeater);
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
        try {
            subscriber.onSubscribe(new RepeatSubscription(this, subscriber, contextMap, contextProvider));
        }
        catch (Throwable cause) {
            SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, cause);
        }
    }

    private static final class RepeatSubscription<T>
    implements PublisherSource.Subscription {
        private static final AtomicLongFieldUpdater<RepeatSubscription> outstandingDemandUpdater = AtomicLongFieldUpdater.newUpdater(RepeatSubscription.class, "outstandingDemand");
        private static final long TERMINATED = Long.MIN_VALUE;
        private static final long CANCELLED = -9223372036854775807L;
        private static final long MIN_INVALID_N = -9223372036854775806L;
        private final RepeatWhenSingle<T> outer;
        private final SequentialCancellable sequentialCancellable = new SequentialCancellable();
        private final PublisherSource.Subscriber<? super T> subscriber;
        private final ContextMap contextMap;
        private final AsyncContextProvider contextProvider;
        private final RepeatSubscriber repeatSubscriber = new RepeatSubscriber();
        private volatile long outstandingDemand;
        private int repeatCount;

        private RepeatSubscription(RepeatWhenSingle<T> outer, PublisherSource.Subscriber<? super T> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
            this.outer = outer;
            this.subscriber = subscriber;
            this.contextMap = contextMap;
            this.contextProvider = contextProvider;
        }

        @Override
        public void request(long n) {
            if (SubscriberUtils.isRequestNValid(n)) {
                long prev = outstandingDemandUpdater.getAndAccumulate(this, n, FlowControlUtils::addWithOverflowProtectionIfNotNegative);
                if (prev == 0L) {
                    ((RepeatWhenSingle)this.outer).original.delegateSubscribe(this.repeatSubscriber, this.contextMap, this.contextProvider);
                }
            } else {
                this.requestNInvalid(n);
            }
        }

        private void requestNInvalid(long n) {
            long prev;
            while ((prev = this.outstandingDemand) != Long.MIN_VALUE) {
                if (prev == 0L) {
                    if (!outstandingDemandUpdater.compareAndSet(this, prev, Long.MIN_VALUE)) continue;
                    this.subscriber.onError(SubscriberUtils.newExceptionForInvalidRequestN(n));
                    continue;
                }
                if (!outstandingDemandUpdater.compareAndSet(this, prev, RepeatSubscription.sanitize(n))) continue;
                break;
            }
        }

        private static long sanitize(long n) {
            return n == 0L ? -1L : Math.max(n, -9223372036854775806L);
        }

        @Override
        public void cancel() {
            long prev;
            while ((prev = this.outstandingDemand) >= 0L && !outstandingDemandUpdater.compareAndSet(this, prev, -9223372036854775807L)) {
            }
            this.sequentialCancellable.cancel();
        }

        private final class RepeatSubscriber
        implements SingleSource.Subscriber<T> {
            private final CompletableSource.Subscriber completableSubscriber = new CompletableSource.Subscriber(){

                @Override
                public void onSubscribe(Cancellable cancellable) {
                    RepeatSubscription.this.sequentialCancellable.nextCancellable(cancellable);
                }

                @Override
                public void onComplete() {
                    block2: {
                        long prev;
                        do {
                            prev = RepeatSubscription.this.outstandingDemand;
                            assert (prev != Long.MIN_VALUE && prev != 0L);
                            if (prev == -9223372036854775807L) break block2;
                            if (prev >= 0L) continue;
                            RepeatSubscriber.this.onErrorInternal(SubscriberUtils.newExceptionForInvalidRequestN(prev));
                            break block2;
                        } while (!outstandingDemandUpdater.compareAndSet(RepeatSubscription.this, prev, prev - 1L));
                        if (prev <= 1L) break block2;
                        RepeatSubscription.this.outer.original.delegateSubscribe(RepeatSubscriber.this, RepeatSubscription.this.contextMap, RepeatSubscription.this.contextProvider);
                    }
                }

                @Override
                public void onError(Throwable t) {
                    RepeatSubscription.this.outstandingDemand = Long.MIN_VALUE;
                    RepeatSubscription.this.subscriber.onComplete();
                }
            };

            private RepeatSubscriber() {
            }

            @Override
            public void onSubscribe(Cancellable cancellable) {
                RepeatSubscription.this.sequentialCancellable.nextCancellable(cancellable);
            }

            @Override
            public void onSuccess(@Nullable T result) {
                Completable completable;
                try {
                    RepeatSubscription.this.subscriber.onNext(result);
                    completable = (Completable)Objects.requireNonNull(RepeatSubscription.this.outer.repeater.apply(++RepeatSubscription.this.repeatCount, result));
                }
                catch (Throwable cause) {
                    this.onErrorInternal(cause);
                    return;
                }
                completable.subscribeInternal(this.completableSubscriber);
            }

            @Override
            public void onError(Throwable t) {
                this.onErrorInternal(t);
            }

            private void onErrorInternal(Throwable t) {
                RepeatSubscription.this.outstandingDemand = Long.MIN_VALUE;
                RepeatSubscription.this.subscriber.onError(t);
            }
        }
    }
}

