/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractSynchronousCompletable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.concurrent.internal.ThreadInterruptingCancellable;
import java.util.Objects;

final class RunnableCompletable
extends AbstractSynchronousCompletable {
    private final Runnable runnable;

    RunnableCompletable(Runnable runnable) {
        this.runnable = Objects.requireNonNull(runnable);
    }

    @Override
    void doSubscribe(CompletableSource.Subscriber subscriber) {
        ThreadInterruptingCancellable cancellable = new ThreadInterruptingCancellable(Thread.currentThread());
        try {
            subscriber.onSubscribe(cancellable);
        }
        catch (Throwable cause) {
            SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, cause);
            return;
        }
        try {
            this.runnable.run();
        }
        catch (Throwable cause) {
            cancellable.setDone(cause);
            SubscriberUtils.safeOnError(subscriber, cause);
            return;
        }
        cancellable.setDone();
        SubscriberUtils.safeOnComplete(subscriber);
    }
}

