/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.PublishAndSubscribeOnPublishers;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.ConcurrentSubscription;
import io.servicetalk.concurrent.internal.ConcurrentTerminalSubscriber;
import io.servicetalk.concurrent.internal.EmptySubscriptions;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

final class TimeoutPublisher<T>
extends AbstractNoHandleSubscribePublisher<T> {
    private final Publisher<T> original;
    private final Executor timeoutExecutor;
    private final long durationNs;
    private final boolean restartAtOnNext;

    TimeoutPublisher(Publisher<T> original, long duration, TimeUnit unit, boolean restartAtOnNext, Executor timeoutExecutor) {
        this.original = Objects.requireNonNull(original);
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor);
        this.durationNs = Math.max(0L, unit.toNanos(duration));
        this.restartAtOnNext = restartAtOnNext;
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(TimeoutSubscriber.newInstance(this, subscriber, contextMap, contextProvider), contextMap, contextProvider);
    }

    private static final class TimeoutSubscriber<X>
    implements PublisherSource.Subscriber<X>,
    PublisherSource.Subscription {
        private static final Cancellable LOCAL_IGNORE_CANCEL = () -> {};
        private static final Cancellable TIMER_PROCESSING = () -> {};
        private static final Cancellable TIMER_FIRED = () -> {};
        private static final AtomicReferenceFieldUpdater<TimeoutSubscriber, Cancellable> timerCancellableUpdater = AtomicReferenceFieldUpdater.newUpdater(TimeoutSubscriber.class, Cancellable.class, "timerCancellable");
        private static final AtomicReferenceFieldUpdater<TimeoutSubscriber, PublisherSource.Subscription> subscriptionUpdater = AtomicReferenceFieldUpdater.newUpdater(TimeoutSubscriber.class, PublisherSource.Subscription.class, "subscription");
        private final TimeoutPublisher<X> parent;
        private final ConcurrentTerminalSubscriber<? super X> target;
        private final AsyncContextProvider contextProvider;
        @Nullable
        private volatile PublisherSource.Subscription subscription;
        @Nullable
        private volatile Cancellable timerCancellable;
        private volatile long lastStartNS;

        private TimeoutSubscriber(TimeoutPublisher<X> parent, PublisherSource.Subscriber<? super X> target, AsyncContextProvider contextProvider) {
            this.parent = parent;
            this.target = new ConcurrentTerminalSubscriber<X>(target);
            this.contextProvider = contextProvider;
        }

        static <X> TimeoutSubscriber<X> newInstance(TimeoutPublisher<X> parent, PublisherSource.Subscriber<? super X> target, ContextMap contextMap, AsyncContextProvider contextProvider) {
            TimeoutSubscriber<? super X> s = new TimeoutSubscriber<X>(parent, target, contextProvider);
            try {
                s.lastStartNS = ((TimeoutPublisher)parent).timeoutExecutor.currentTime(TimeUnit.NANOSECONDS);
                timerCancellableUpdater.compareAndSet(s, null, Objects.requireNonNull(((TimeoutPublisher)parent).timeoutExecutor.schedule(s::timerFires, ((TimeoutPublisher)parent).durationNs, TimeUnit.NANOSECONDS)));
            }
            catch (Throwable cause) {
                TimeoutSubscriber.handleConstructorException(s, contextMap, contextProvider, cause);
            }
            return s;
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription s) {
            if (subscriptionUpdater.compareAndSet(this, null, ConcurrentSubscription.wrap(s))) {
                this.target.onSubscribe(this);
            } else {
                s.cancel();
            }
        }

        @Override
        public void onNext(X x) {
            if (((TimeoutPublisher)this.parent).restartAtOnNext) {
                this.lastStartNS = ((TimeoutPublisher)this.parent).timeoutExecutor.currentTime(TimeUnit.NANOSECONDS);
            }
            this.target.onNext(x);
        }

        @Override
        public void onError(Throwable t) {
            if (this.target.processOnError(t)) {
                this.stopTimer();
            }
        }

        @Override
        public void onComplete() {
            if (this.target.processOnComplete()) {
                this.stopTimer();
            }
        }

        @Override
        public void request(long n) {
            PublisherSource.Subscription subscription = this.subscription;
            assert (subscription != null);
            subscription.request(n);
        }

        @Override
        public void cancel() {
            PublisherSource.Subscription subscription = this.subscription;
            assert (subscription != null);
            try {
                this.stopTimer();
            }
            finally {
                subscription.cancel();
            }
        }

        private void timerFires() {
            Cancellable previousTimerCancellable;
            while (true) {
                if ((previousTimerCancellable = this.timerCancellable) == LOCAL_IGNORE_CANCEL || previousTimerCancellable == TIMER_FIRED) {
                    return;
                }
                if (previousTimerCancellable == TIMER_PROCESSING) {
                    if (!timerCancellableUpdater.compareAndSet(this, TIMER_PROCESSING, TIMER_FIRED)) continue;
                    return;
                }
                if (timerCancellableUpdater.compareAndSet(this, previousTimerCancellable, TIMER_PROCESSING)) break;
            }
            block3: while (true) {
                Cancellable nextTimerCancellable;
                long currentTimeNs = ((TimeoutPublisher)this.parent).timeoutExecutor.currentTime(TimeUnit.NANOSECONDS);
                long nextTimeoutNs = ((TimeoutPublisher)this.parent).durationNs - (currentTimeNs - this.lastStartNS);
                if (nextTimeoutNs <= 0L) {
                    this.offloadTimeout(new TimeoutException("timeout after " + TimeUnit.NANOSECONDS.toMillis(((TimeoutPublisher)this.parent).durationNs) + "ms"));
                    return;
                }
                try {
                    nextTimerCancellable = Objects.requireNonNull(((TimeoutPublisher)this.parent).timeoutExecutor.schedule(this::timerFires, nextTimeoutNs, TimeUnit.NANOSECONDS));
                }
                catch (Throwable cause) {
                    this.offloadTimeout(cause);
                    return;
                }
                if (timerCancellableUpdater.compareAndSet(this, previousTimerCancellable, nextTimerCancellable)) {
                    return;
                }
                while (true) {
                    if ((previousTimerCancellable = this.timerCancellable) == LOCAL_IGNORE_CANCEL) {
                        nextTimerCancellable.cancel();
                        return;
                    }
                    if (previousTimerCancellable == TIMER_FIRED) {
                        if (!timerCancellableUpdater.compareAndSet(this, TIMER_FIRED, TIMER_PROCESSING)) continue;
                        previousTimerCancellable = TIMER_PROCESSING;
                        continue block3;
                    }
                    if (timerCancellableUpdater.compareAndSet(this, previousTimerCancellable, nextTimerCancellable)) break block3;
                }
                break;
            }
        }

        private void offloadTimeout(Throwable cause) {
            if (Executors.immediate() == ((TimeoutPublisher)this.parent).timeoutExecutor) {
                this.processTimeout(cause);
            } else {
                this.contextProvider.wrapConsumer(this::processTimeout, this.contextProvider.context()).accept(cause);
            }
        }

        private void processTimeout(Throwable cause) {
            PublisherSource.Subscription subscription = subscriptionUpdater.getAndSet(this, EmptySubscriptions.EMPTY_SUBSCRIPTION);
            if (subscription != null) {
                subscription.cancel();
            } else {
                this.target.onSubscribe(EmptySubscriptions.EMPTY_SUBSCRIPTION);
            }
            this.target.processOnError(cause);
        }

        private void stopTimer() {
            timerCancellableUpdater.getAndSet(this, LOCAL_IGNORE_CANCEL).cancel();
        }

        private static <X> void handleConstructorException(TimeoutSubscriber<X> s, ContextMap contextMap, AsyncContextProvider contextProvider, Throwable cause) {
            s.timerCancellable = LOCAL_IGNORE_CANCEL;
            s.subscription = EmptySubscriptions.EMPTY_SUBSCRIPTION;
            PublishAndSubscribeOnPublishers.deliverOnSubscribeAndOnError(s.target, contextMap, contextProvider, cause);
        }
    }
}

