/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.http.api.BlockingStreamingHttpServerResponse;
import io.servicetalk.http.api.DefaultHttpResponseMetaData;
import io.servicetalk.http.api.HttpCookiePair;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpOutputStream;
import io.servicetalk.http.api.HttpPayloadWriter;
import io.servicetalk.http.api.HttpPayloadWriterToHttpOutputStream;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.HttpSetCookie;
import io.servicetalk.http.api.HttpStreamingSerializer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;

final class DefaultBlockingStreamingHttpServerResponse
extends DefaultHttpResponseMetaData
implements BlockingStreamingHttpServerResponse {
    private static final AtomicIntegerFieldUpdater<DefaultBlockingStreamingHttpServerResponse> metaSentUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultBlockingStreamingHttpServerResponse.class, "metaSent");
    private volatile int metaSent;
    private final Consumer<DefaultHttpResponseMetaData> sendMeta;
    private final HttpPayloadWriter<Buffer> payloadWriter;
    private final BufferAllocator allocator;

    DefaultBlockingStreamingHttpServerResponse(HttpResponseStatus status, HttpProtocolVersion version, HttpHeaders headers, HttpPayloadWriter<Buffer> payloadWriter, BufferAllocator allocator, Consumer<DefaultHttpResponseMetaData> sendMeta) {
        super(status, version, headers, null);
        this.payloadWriter = Objects.requireNonNull(payloadWriter);
        this.allocator = Objects.requireNonNull(allocator);
        this.sendMeta = sendMeta;
    }

    @Override
    public BlockingStreamingHttpServerResponse version(HttpProtocolVersion version) {
        this.checkSent();
        super.version(version);
        return this;
    }

    @Override
    public BlockingStreamingHttpServerResponse status(HttpResponseStatus status) {
        this.checkSent();
        super.status(status);
        return this;
    }

    @Override
    public BlockingStreamingHttpServerResponse addHeader(CharSequence name, CharSequence value) {
        this.checkSent();
        super.addHeader(name, value);
        return this;
    }

    @Override
    public BlockingStreamingHttpServerResponse addHeaders(HttpHeaders headers) {
        this.checkSent();
        super.addHeaders(headers);
        return this;
    }

    @Override
    public BlockingStreamingHttpServerResponse setHeader(CharSequence name, CharSequence value) {
        this.checkSent();
        super.setHeader(name, value);
        return this;
    }

    @Override
    public BlockingStreamingHttpServerResponse setHeaders(HttpHeaders headers) {
        this.checkSent();
        super.setHeaders(headers);
        return this;
    }

    @Override
    public BlockingStreamingHttpServerResponse addCookie(HttpCookiePair cookie) {
        this.checkSent();
        super.addCookie(cookie);
        return this;
    }

    @Override
    public BlockingStreamingHttpServerResponse addCookie(CharSequence name, CharSequence value) {
        this.checkSent();
        super.addCookie(name, value);
        return this;
    }

    @Override
    public BlockingStreamingHttpServerResponse addSetCookie(HttpSetCookie cookie) {
        this.checkSent();
        super.addSetCookie(cookie);
        return this;
    }

    @Override
    public BlockingStreamingHttpServerResponse addSetCookie(CharSequence name, CharSequence value) {
        this.checkSent();
        super.addSetCookie(name, value);
        return this;
    }

    @Override
    public BlockingStreamingHttpServerResponse context(ContextMap context) {
        this.checkSent();
        super.context(context);
        return this;
    }

    private void checkSent() {
        if (this.metaSent != 0) {
            DefaultBlockingStreamingHttpServerResponse.throwMetaAlreadySent();
        }
    }

    @Override
    public HttpPayloadWriter<Buffer> sendMetaData() {
        if (!this.markMetaSent()) {
            DefaultBlockingStreamingHttpServerResponse.throwMetaAlreadySent();
        }
        this.sendMeta.accept(this);
        return this.payloadWriter;
    }

    @Override
    public <T> HttpPayloadWriter<T> sendMetaData(HttpSerializer<T> serializer) {
        HttpPayloadWriter<T> payloadWriter = serializer.serialize(this.headers(), this.payloadWriter, this.allocator);
        this.sendMetaData();
        return payloadWriter;
    }

    @Override
    public <T> HttpPayloadWriter<T> sendMetaData(HttpStreamingSerializer<T> serializer) {
        HttpPayloadWriter<T> payloadWriter = serializer.serialize(this.headers(), this.payloadWriter, this.allocator);
        this.sendMetaData();
        return payloadWriter;
    }

    @Override
    public HttpOutputStream sendMetaDataOutputStream() {
        return new HttpPayloadWriterToHttpOutputStream(this.sendMetaData(), this.allocator);
    }

    boolean markMetaSent() {
        return metaSentUpdater.compareAndSet(this, 0, 1);
    }

    private static void throwMetaAlreadySent() {
        throw new IllegalStateException("Response meta-data is already sent");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultBlockingStreamingHttpServerResponse that = (DefaultBlockingStreamingHttpServerResponse)o;
        return this.metaSent == that.metaSent && this.sendMeta.equals(that.sendMeta) && this.payloadWriter.equals(that.payloadWriter) && this.allocator.equals(that.allocator);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.metaSent;
        result = 31 * result + this.sendMeta.hashCode();
        result = 31 * result + this.payloadWriter.hashCode();
        result = 31 * result + this.allocator.hashCode();
        return result;
    }
}

