/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.internal.SubscribableSingle;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.function.Function;

final class FunctionToSingle<T, R>
extends SubscribableSingle<R> {
    private final Function<T, R> func;
    private final T orig;

    FunctionToSingle(Function<T, R> func, T orig) {
        this.func = func;
        this.orig = orig;
    }

    @Override
    protected void handleSubscribe(SingleSource.Subscriber<? super R> subscriber) {
        R result;
        try {
            subscriber.onSubscribe(Cancellable.IGNORE_CANCEL);
        }
        catch (Throwable cause) {
            SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, cause);
            return;
        }
        try {
            result = this.func.apply(this.orig);
        }
        catch (Throwable t) {
            subscriber.onError(t);
            return;
        }
        subscriber.onSuccess(result);
    }
}

