/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.http.api.ConnectAndHttpExecutionStrategy;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpLoadBalancerFactory;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.transport.api.ConnectExecutionStrategy;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.ExecutionStrategyInfluencer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientStrategyInfluencerChainBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientStrategyInfluencerChainBuilder.class);
    @Nullable
    private ConnectAndHttpExecutionStrategy connFactoryChain;
    @Nullable
    private HttpExecutionStrategy connFilterChain;
    @Nullable
    private HttpExecutionStrategy clientChain;

    ClientStrategyInfluencerChainBuilder() {
        this.connFactoryChain = null;
        this.connFilterChain = null;
        this.clientChain = null;
    }

    private ClientStrategyInfluencerChainBuilder(ClientStrategyInfluencerChainBuilder from) {
        this.connFactoryChain = from.connFactoryChain;
        this.connFilterChain = from.connFilterChain;
        this.clientChain = from.clientChain;
    }

    void add(StreamingHttpClientFilterFactory clientFilter) {
        this.add("filter", clientFilter, clientFilter.requiredOffloads());
    }

    void add(HttpLoadBalancerFactory<?> lb) {
        this.add("load balancer", lb, lb.requiredOffloads());
    }

    private void add(String purpose, ExecutionStrategyInfluencer<?> influencer, HttpExecutionStrategy strategy) {
        if (HttpExecutionStrategies.offloadNever() == strategy) {
            LOGGER.warn("Ignoring illegal {} required strategy ({}) for {}", purpose, strategy, influencer);
            strategy = HttpExecutionStrategies.offloadNone();
        }
        if (strategy.hasOffloads()) {
            this.clientChain = null != this.clientChain ? this.clientChain.merge(strategy) : strategy;
        }
    }

    void add(ConnectionFactoryFilter<?, FilterableStreamingHttpConnection> connectionFactoryFilter) {
        ExecutionStrategy filterOffloads = connectionFactoryFilter.requiredOffloads();
        if (HttpExecutionStrategies.offloadNever() == filterOffloads) {
            LOGGER.warn("Ignoring illegal connection factory required strategy ({}) for {}", (Object)filterOffloads, (Object)connectionFactoryFilter);
            filterOffloads = HttpExecutionStrategies.offloadNone();
        }
        if (filterOffloads.hasOffloads()) {
            this.connFactoryChain = null != this.connFactoryChain ? this.connFactoryChain.merge(filterOffloads) : ConnectAndHttpExecutionStrategy.from(filterOffloads);
        }
    }

    void add(StreamingHttpConnectionFilterFactory connectionFilter) {
        HttpExecutionStrategy filterOffloads = connectionFilter.requiredOffloads();
        if (HttpExecutionStrategies.offloadNever() == filterOffloads) {
            LOGGER.warn("Ignoring illegal connection filter required strategy ({}) for {}", (Object)filterOffloads, (Object)connectionFilter);
            filterOffloads = HttpExecutionStrategies.offloadNone();
        }
        if (filterOffloads.hasOffloads()) {
            this.connFilterChain = null != this.connFilterChain ? this.connFilterChain.merge(filterOffloads) : filterOffloads;
        }
    }

    HttpExecutionStrategy buildForClient(HttpExecutionStrategy transportStrategy) {
        HttpExecutionStrategy clientStrategy;
        HttpExecutionStrategy httpExecutionStrategy = clientStrategy = null != this.clientChain ? transportStrategy.merge(this.clientChain) : transportStrategy;
        if (null != this.connFilterChain) {
            clientStrategy = clientStrategy.merge(this.connFilterChain);
        }
        if (null != this.connFactoryChain) {
            clientStrategy = clientStrategy.merge(HttpExecutionStrategy.from(this.buildForConnectionFactory()));
        }
        return clientStrategy;
    }

    ExecutionStrategy buildForConnectionFactory() {
        return null == this.connFactoryChain ? ExecutionStrategy.offloadNone() : (HttpExecutionStrategies.defaultStrategy() != this.connFactoryChain.httpStrategy() ? (ConnectExecutionStrategy.offloadNone() != this.connFactoryChain.connectStrategy() ? this.connFactoryChain : this.connFactoryChain.httpStrategy()) : (ConnectExecutionStrategy.offloadNone() != this.connFactoryChain.connectStrategy() ? this.connFactoryChain.connectStrategy() : ExecutionStrategy.offloadNone()));
    }

    ClientStrategyInfluencerChainBuilder copy() {
        return new ClientStrategyInfluencerChainBuilder(this);
    }
}

