/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.BlockingHttpClient;
import io.servicetalk.http.api.BlockingStreamingHttpClient;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.HttpApiConversions;
import io.servicetalk.http.api.HttpClient;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpContextKeys;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.ReservedBlockingHttpConnection;
import io.servicetalk.http.api.ReservedBlockingStreamingHttpConnection;
import io.servicetalk.http.api.ReservedHttpConnection;
import io.servicetalk.http.api.ReservedStreamingHttpConnection;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;

final class FilterableClientToClient
implements StreamingHttpClient {
    private final FilterableStreamingHttpClient client;
    private final HttpExecutionStrategy strategy;

    FilterableClientToClient(FilterableStreamingHttpClient filteredClient, HttpExecutionStrategy strategy) {
        this.client = filteredClient;
        this.strategy = strategy;
    }

    @Override
    public HttpClient asClient() {
        return HttpApiConversions.toClient((StreamingHttpClient)this, this.strategy);
    }

    @Override
    public BlockingStreamingHttpClient asBlockingStreamingClient() {
        return HttpApiConversions.toBlockingStreamingClient((StreamingHttpClient)this, this.strategy);
    }

    @Override
    public BlockingHttpClient asBlockingClient() {
        return HttpApiConversions.toBlockingClient((StreamingHttpClient)this, this.strategy);
    }

    @Override
    public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
        return Single.defer(() -> {
            request.context().putIfAbsent(HttpContextKeys.HTTP_EXECUTION_STRATEGY_KEY, this.strategy);
            return this.client.request(request).shareContextOnSubscribe();
        });
    }

    @Override
    public Single<ReservedStreamingHttpConnection> reserveConnection(HttpRequestMetaData metaData) {
        return Single.defer(() -> {
            metaData.context().putIfAbsent(HttpContextKeys.HTTP_EXECUTION_STRATEGY_KEY, this.strategy);
            return this.client.reserveConnection(metaData).map(rc -> new ReservedStreamingHttpConnection((FilterableReservedStreamingHttpConnection)rc){
                final /* synthetic */ FilterableReservedStreamingHttpConnection val$rc;
                {
                    this.val$rc = filterableReservedStreamingHttpConnection;
                }

                @Override
                public ReservedHttpConnection asConnection() {
                    return HttpApiConversions.toReservedConnection((ReservedStreamingHttpConnection)this, FilterableClientToClient.this.strategy);
                }

                @Override
                public ReservedBlockingStreamingHttpConnection asBlockingStreamingConnection() {
                    return HttpApiConversions.toReservedBlockingStreamingConnection((ReservedStreamingHttpConnection)this, FilterableClientToClient.this.strategy);
                }

                @Override
                public ReservedBlockingHttpConnection asBlockingConnection() {
                    return HttpApiConversions.toReservedBlockingConnection((ReservedStreamingHttpConnection)this, FilterableClientToClient.this.strategy);
                }

                @Override
                public Completable releaseAsync() {
                    return this.val$rc.releaseAsync();
                }

                @Override
                public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
                    return Single.defer(() -> {
                        request.context().putIfAbsent(HttpContextKeys.HTTP_EXECUTION_STRATEGY_KEY, FilterableClientToClient.this.strategy);
                        return this.val$rc.request(request).shareContextOnSubscribe();
                    });
                }

                @Override
                public HttpConnectionContext connectionContext() {
                    return this.val$rc.connectionContext();
                }

                @Override
                public <T> Publisher<? extends T> transportEventStream(HttpEventKey<T> eventKey) {
                    return this.val$rc.transportEventStream(eventKey);
                }

                @Override
                public HttpExecutionContext executionContext() {
                    return this.val$rc.executionContext();
                }

                @Override
                public StreamingHttpResponseFactory httpResponseFactory() {
                    return this.val$rc.httpResponseFactory();
                }

                @Override
                public Completable onClose() {
                    return this.val$rc.onClose();
                }

                @Override
                public Completable closeAsync() {
                    return this.val$rc.closeAsync();
                }

                @Override
                public Completable closeAsyncGracefully() {
                    return this.val$rc.closeAsyncGracefully();
                }

                @Override
                public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
                    return this.val$rc.newRequest(method, requestTarget);
                }
            }).shareContextOnSubscribe();
        });
    }

    @Override
    public HttpExecutionContext executionContext() {
        return this.client.executionContext();
    }

    @Override
    public StreamingHttpResponseFactory httpResponseFactory() {
        return this.client.httpResponseFactory();
    }

    @Override
    public Completable onClose() {
        return this.client.onClose();
    }

    @Override
    public Completable closeAsync() {
        return this.client.closeAsync();
    }

    @Override
    public Completable closeAsyncGracefully() {
        return this.client.closeAsyncGracefully();
    }

    @Override
    public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
        return this.client.newRequest(method, requestTarget);
    }
}

