/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.http.api.DefaultHttpHeadersFactory;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.netty.H1ProtocolConfig;
import io.servicetalk.http.netty.H1SpecExceptions;
import java.util.Objects;

public final class H1ProtocolConfigBuilder {
    private static final H1SpecExceptions DEFAULT_H1_SPEC_EXCEPTIONS = new H1SpecExceptions.Builder().build();
    private int maxPipelinedRequests = 1;
    private int maxStartLineLength = 4096;
    private int maxHeaderFieldLength = 8192;
    private HttpHeadersFactory headersFactory = DefaultHttpHeadersFactory.INSTANCE;
    private int headersEncodedSizeEstimate = 256;
    private int trailersEncodedSizeEstimate = 256;
    private H1SpecExceptions specExceptions = DEFAULT_H1_SPEC_EXCEPTIONS;

    H1ProtocolConfigBuilder() {
    }

    public H1ProtocolConfigBuilder headersFactory(HttpHeadersFactory headersFactory) {
        this.headersFactory = Objects.requireNonNull(headersFactory);
        return this;
    }

    public H1ProtocolConfigBuilder maxPipelinedRequests(int maxPipelinedRequests) {
        this.maxPipelinedRequests = maxPipelinedRequests;
        return this;
    }

    public H1ProtocolConfigBuilder maxStartLineLength(int maxStartLineLength) {
        this.maxStartLineLength = maxStartLineLength;
        return this;
    }

    public H1ProtocolConfigBuilder maxHeaderFieldLength(int maxHeaderFieldLength) {
        this.maxHeaderFieldLength = maxHeaderFieldLength;
        return this;
    }

    public H1ProtocolConfigBuilder headersEncodedSizeEstimate(int headersEncodedSizeEstimate) {
        this.headersEncodedSizeEstimate = headersEncodedSizeEstimate;
        return this;
    }

    public H1ProtocolConfigBuilder trailersEncodedSizeEstimate(int trailersEncodedSizeEstimate) {
        this.trailersEncodedSizeEstimate = trailersEncodedSizeEstimate;
        return this;
    }

    public H1ProtocolConfigBuilder specExceptions(H1SpecExceptions specExceptions) {
        this.specExceptions = Objects.requireNonNull(specExceptions);
        return this;
    }

    public H1ProtocolConfig build() {
        return new DefaultH1ProtocolConfig(this.headersFactory, this.maxPipelinedRequests, this.maxStartLineLength, this.maxHeaderFieldLength, this.headersEncodedSizeEstimate, this.trailersEncodedSizeEstimate, this.specExceptions);
    }

    private static final class DefaultH1ProtocolConfig
    implements H1ProtocolConfig {
        private final HttpHeadersFactory headersFactory;
        private final int maxPipelinedRequests;
        private final int maxStartLineLength;
        private final int maxHeaderFieldLength;
        private final int headersEncodedSizeEstimate;
        private final int trailersEncodedSizeEstimate;
        private final H1SpecExceptions specExceptions;

        DefaultH1ProtocolConfig(HttpHeadersFactory headersFactory, int maxPipelinedRequests, int maxStartLineLength, int maxHeaderFieldLength, int headersEncodedSizeEstimate, int trailersEncodedSizeEstimate, H1SpecExceptions specExceptions) {
            this.headersFactory = headersFactory;
            this.maxPipelinedRequests = maxPipelinedRequests;
            this.maxStartLineLength = maxStartLineLength;
            this.maxHeaderFieldLength = maxHeaderFieldLength;
            this.headersEncodedSizeEstimate = headersEncodedSizeEstimate;
            this.trailersEncodedSizeEstimate = trailersEncodedSizeEstimate;
            this.specExceptions = specExceptions;
        }

        @Override
        public HttpHeadersFactory headersFactory() {
            return this.headersFactory;
        }

        @Override
        public int maxPipelinedRequests() {
            return this.maxPipelinedRequests;
        }

        @Override
        public int maxStartLineLength() {
            return this.maxStartLineLength;
        }

        @Override
        public int maxHeaderFieldLength() {
            return this.maxHeaderFieldLength;
        }

        @Override
        public int headersEncodedSizeEstimate() {
            return this.headersEncodedSizeEstimate;
        }

        @Override
        public int trailersEncodedSizeEstimate() {
            return this.trailersEncodedSizeEstimate;
        }

        @Override
        public H1SpecExceptions specExceptions() {
            return this.specExceptions;
        }
    }
}

