/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.netty.HeaderUtils;
import io.servicetalk.http.netty.NettyH2HeadersToHttpHeaders;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

final class H2ToStH1Utils {
    private H2ToStH1Utils() {
    }

    static void h2HeadersSanitizeForH1(Http2Headers h2Headers) {
        H2ToStH1Utils.h2HeadersCompressCookieCrumbs(h2Headers);
    }

    static void h2HeadersCompressCookieCrumbs(Http2Headers h2Headers) {
        Iterator<CharSequence> cookieItr = h2Headers.valueIterator(HttpHeaderNames.COOKIE);
        if (cookieItr.hasNext()) {
            CharSequence prevCookItr = cookieItr.next();
            if (cookieItr.hasNext()) {
                CharSequence cookieHeader = cookieItr.next();
                StringBuilder sb = new StringBuilder(prevCookItr.length() * 2 + cookieHeader.length() + 2);
                sb.append(prevCookItr).append("; ").append(cookieHeader);
                while (cookieItr.hasNext()) {
                    cookieHeader = cookieItr.next();
                    sb.append("; ").append(cookieHeader);
                }
                h2Headers.set(HttpHeaderNames.COOKIE, sb.toString());
            }
        }
    }

    static void h1HeadersSplitCookieCrumbs(HttpHeaders h1Headers) {
        Iterator<? extends CharSequence> cookieItr = h1Headers.valuesIterator(io.servicetalk.http.api.HttpHeaderNames.COOKIE);
        ArrayList<CharSequence> cookiesToAdd = null;
        while (cookieItr.hasNext()) {
            CharSequence nextCookie = cookieItr.next();
            int i = HeaderUtils.indexOf(nextCookie, ';', 0);
            if (i <= 0) continue;
            if (cookiesToAdd == null) {
                cookiesToAdd = new ArrayList<CharSequence>(4);
            }
            int start = 0;
            do {
                cookiesToAdd.add(nextCookie.subSequence(start, i));
            } while ((start = i + 2) < nextCookie.length() && (i = HeaderUtils.indexOf(nextCookie, ';', start)) >= 0);
            cookiesToAdd.add(nextCookie.subSequence(start, nextCookie.length()));
            cookieItr.remove();
        }
        if (cookiesToAdd != null) {
            for (CharSequence crumb : cookiesToAdd) {
                h1Headers.add(io.servicetalk.http.api.HttpHeaderNames.COOKIE, crumb);
            }
        }
    }

    static Http2Headers h1HeadersToH2Headers(HttpHeaders h1Headers) {
        if (h1Headers.isEmpty()) {
            if (h1Headers instanceof NettyH2HeadersToHttpHeaders) {
                return ((NettyH2HeadersToHttpHeaders)h1Headers).nettyHeaders();
            }
            return new DefaultHttp2Headers(false, 0);
        }
        Iterator<? extends CharSequence> connectionItr = h1Headers.valuesIterator(io.servicetalk.http.api.HttpHeaderNames.CONNECTION);
        if (connectionItr.hasNext()) {
            do {
                String connectionHeader = connectionItr.next().toString();
                connectionItr.remove();
                int i = connectionHeader.indexOf(44);
                if (i != -1) {
                    int start = 0;
                    do {
                        h1Headers.remove(connectionHeader.substring(start, i));
                    } while ((start = i + 1) < connectionHeader.length() && (i = connectionHeader.indexOf(44, start)) != -1);
                    h1Headers.remove(connectionHeader.substring(start));
                    continue;
                }
                h1Headers.remove(connectionHeader);
            } while (connectionItr.hasNext());
        }
        h1Headers.remove(io.servicetalk.http.api.HttpHeaderValues.KEEP_ALIVE);
        h1Headers.remove(io.servicetalk.http.api.HttpHeaderNames.TRANSFER_ENCODING);
        h1Headers.remove(io.servicetalk.http.api.HttpHeaderNames.UPGRADE);
        Iterator<? extends CharSequence> teItr = h1Headers.valuesIterator(HttpHeaderNames.TE);
        boolean addTrailers = false;
        while (teItr.hasNext()) {
            String teValue = teItr.next().toString();
            int i = teValue.indexOf(44);
            if (i != -1) {
                int start = 0;
                do {
                    if (teValue.substring(start, i).compareToIgnoreCase(HttpHeaderValues.TRAILERS.toString()) != 0) continue;
                    addTrailers = true;
                    break;
                } while (start < teValue.length() && (i = teValue.indexOf(44, start)) != -1);
                teItr.remove();
                continue;
            }
            if (teValue.compareToIgnoreCase(HttpHeaderValues.TRAILERS.toString()) == 0) continue;
            teItr.remove();
        }
        if (addTrailers) {
            h1Headers.add((CharSequence)HttpHeaderNames.TE, (CharSequence)HttpHeaderValues.TRAILERS);
        }
        H2ToStH1Utils.h1HeadersSplitCookieCrumbs(h1Headers);
        if (h1Headers instanceof NettyH2HeadersToHttpHeaders) {
            return ((NettyH2HeadersToHttpHeaders)h1Headers).nettyHeaders();
        }
        if (h1Headers.isEmpty()) {
            return new DefaultHttp2Headers(false, 0);
        }
        DefaultHttp2Headers http2Headers = new DefaultHttp2Headers(false);
        for (Map.Entry<CharSequence, CharSequence> h1Entry : h1Headers) {
            http2Headers.add(h1Entry.getKey().toString().toLowerCase(), h1Entry.getValue());
        }
        return http2Headers;
    }
}

