/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.util.NetUtil;
import io.servicetalk.http.netty.HttpConfig;
import io.servicetalk.http.netty.HttpServerConfig;
import io.servicetalk.http.netty.ReadOnlyHttpClientConfig;
import io.servicetalk.tcp.netty.internal.TcpClientConfig;
import io.servicetalk.transport.api.ClientSslConfig;
import io.servicetalk.transport.api.DelegatingClientSslConfig;
import java.util.List;
import javax.annotation.Nullable;

final class HttpClientConfig {
    private final TcpClientConfig tcpConfig;
    private final HttpConfig protocolConfigs;
    @Nullable
    private CharSequence connectAddress;
    @Nullable
    private String fallbackPeerHost;
    private int fallbackPeerPort = -1;
    private boolean inferPeerHost = true;
    private boolean inferPeerPort = true;
    private boolean inferSniHostname = true;

    HttpClientConfig() {
        this.tcpConfig = new TcpClientConfig();
        this.protocolConfigs = new HttpConfig();
    }

    HttpClientConfig(HttpClientConfig from) {
        this.tcpConfig = new TcpClientConfig(from.tcpConfig());
        this.protocolConfigs = new HttpConfig(from.protocolConfigs());
        this.connectAddress = from.connectAddress;
        this.fallbackPeerHost = from.fallbackPeerHost;
        this.fallbackPeerPort = from.fallbackPeerPort;
        this.inferPeerHost = from.inferPeerHost;
        this.inferPeerPort = from.inferPeerPort;
        this.inferSniHostname = from.inferSniHostname;
    }

    TcpClientConfig tcpConfig() {
        return this.tcpConfig;
    }

    HttpConfig protocolConfigs() {
        return this.protocolConfigs;
    }

    @Nullable
    CharSequence connectAddress() {
        return this.connectAddress;
    }

    void connectAddress(@Nullable CharSequence connectAddress) {
        this.connectAddress = connectAddress;
    }

    void fallbackPeerHost(@Nullable String fallbackPeerHost) {
        this.fallbackPeerHost = fallbackPeerHost;
    }

    void fallbackPeerPort(int fallbackPeerPort) {
        this.fallbackPeerPort = fallbackPeerPort;
    }

    void inferPeerHost(boolean shouldInfer) {
        this.inferPeerHost = shouldInfer;
    }

    void inferPeerPort(boolean shouldInfer) {
        this.inferPeerPort = shouldInfer;
    }

    void inferSniHostname(boolean shouldInfer) {
        this.inferSniHostname = shouldInfer;
    }

    ReadOnlyHttpClientConfig asReadOnly() {
        this.applySslConfigOverrides();
        ReadOnlyHttpClientConfig roConfig = new ReadOnlyHttpClientConfig(this);
        if (roConfig.tcpConfig().sslContext() == null && roConfig.h1Config() != null && roConfig.h2Config() != null) {
            throw new IllegalStateException("Cleartext HTTP/1.1 -> HTTP/2 (h2c) upgrade is not supported");
        }
        return roConfig;
    }

    private void applySslConfigOverrides() {
        final List<String> httpAlpnProtocols = this.protocolConfigs.supportedAlpnProtocols();
        ClientSslConfig sslConfig = (ClientSslConfig)this.tcpConfig.sslConfig();
        if (sslConfig != null) {
            final List<String> configAlpn = sslConfig.alpnProtocols();
            final String configPeerHost = sslConfig.peerHost();
            final int configPeerPort = sslConfig.peerPort();
            final String configSni = sslConfig.sniHostname();
            this.tcpConfig.sslConfig(new DelegatingClientSslConfig(sslConfig){
                @Nullable
                private final List<String> alpnProtocols;
                @Nullable
                private final String peerHost;
                private final int peerPort;
                @Nullable
                private final String sniHostname;
                {
                    super(x0);
                    this.alpnProtocols = HttpServerConfig.httpAlpnProtocols(configAlpn, httpAlpnProtocols);
                    this.peerHost = configPeerHost == null && HttpClientConfig.this.inferPeerHost ? HttpClientConfig.this.fallbackPeerHost : configPeerHost;
                    this.peerPort = configPeerPort < 0 && HttpClientConfig.this.inferPeerPort ? HttpClientConfig.this.fallbackPeerPort : configPeerPort;
                    this.sniHostname = configSni == null && HttpClientConfig.this.inferSniHostname ? HttpClientConfig.filterSniName(HttpClientConfig.this.fallbackPeerHost) : configSni;
                }

                @Override
                public List<String> alpnProtocols() {
                    return this.alpnProtocols;
                }

                @Override
                @Nullable
                public String peerHost() {
                    return this.peerHost;
                }

                @Override
                public int peerPort() {
                    return this.peerPort;
                }

                @Override
                public String sniHostname() {
                    return this.sniHostname;
                }
            });
        }
    }

    @Nullable
    private static String filterSniName(@Nullable String peerHost) {
        return peerHost == null || NetUtil.isValidIpV4Address(peerHost) || NetUtil.isValidIpV6Address(peerHost) ? null : peerHost;
    }
}

