/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.UniformStreamByteDistributor;

final class OptimizedHttp2FrameCodecBuilder
extends Http2FrameCodecBuilder {
    private final boolean server;

    OptimizedHttp2FrameCodecBuilder(boolean server) {
        this.server = server;
    }

    @Override
    public boolean isServer() {
        return this.server;
    }

    @Override
    public Http2FrameCodec build() {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(this.isServer(), this.maxReservedStreams());
        connection.remote().flowController(new DefaultHttp2RemoteFlowController((Http2Connection)connection, new UniformStreamByteDistributor(connection)));
        this.connection(connection);
        return super.build();
    }
}

