/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.Channel;
import io.servicetalk.buffer.netty.BufferUtils;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.netty.H1ProtocolConfig;
import io.servicetalk.http.netty.HeaderUtils;
import io.servicetalk.http.netty.HttpClientChannelInitializer;
import io.servicetalk.http.netty.HttpDebugUtils;
import io.servicetalk.http.netty.ReadOnlyHttpClientConfig;
import io.servicetalk.tcp.netty.internal.ReadOnlyTcpClientConfig;
import io.servicetalk.tcp.netty.internal.TcpClientChannelInitializer;
import io.servicetalk.tcp.netty.internal.TcpConnector;
import io.servicetalk.transport.api.ClientSslConfig;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import io.servicetalk.transport.netty.internal.CloseHandler;
import io.servicetalk.transport.netty.internal.DefaultNettyConnection;
import io.servicetalk.transport.netty.internal.NettyConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Objects;
import javax.net.ssl.SNIHostName;

final class StreamingConnectionFactory {
    private StreamingConnectionFactory() {
    }

    static <ResolvedAddress> Single<? extends NettyConnection<Object, Object>> buildStreaming(HttpExecutionContext executionContext, ResolvedAddress resolvedAddress, ReadOnlyHttpClientConfig roConfig, TransportObserver observer) {
        ReadOnlyTcpClientConfig tcpConfig = StreamingConnectionFactory.withSslConfigPeerHost(resolvedAddress, roConfig.tcpConfig());
        H1ProtocolConfig h1Config = roConfig.h1Config();
        assert (h1Config != null);
        return TcpConnector.connect(null, resolvedAddress, tcpConfig, false, executionContext, (channel, connectionObserver) -> StreamingConnectionFactory.createConnection(channel, executionContext, h1Config, tcpConfig, new TcpClientChannelInitializer(tcpConfig, (ConnectionObserver)connectionObserver, roConfig.hasProxy()), connectionObserver), observer);
    }

    static Single<? extends DefaultNettyConnection<Object, Object>> createConnection(Channel channel, HttpExecutionContext executionContext, H1ProtocolConfig h1Config, ReadOnlyTcpClientConfig tcpConfig, ChannelInitializer initializer, ConnectionObserver connectionObserver) {
        CloseHandler closeHandler = CloseHandler.forPipelinedRequestResponse(true, channel.config());
        return HttpDebugUtils.showPipeline(DefaultNettyConnection.initChannel(channel, executionContext.bufferAllocator(), executionContext.executor(), executionContext.ioExecutor(), closeHandler, tcpConfig.flushStrategy(), tcpConfig.idleTimeoutMs(), initializer.andThen(new HttpClientChannelInitializer(BufferUtils.getByteBufAllocator(executionContext.bufferAllocator()), h1Config, closeHandler)), executionContext.executionStrategy(), HttpProtocolVersion.HTTP_1_1, connectionObserver, true, HeaderUtils.OBJ_EXPECT_CONTINUE), HttpProtocolVersion.HTTP_1_1, channel);
    }

    static ReadOnlyTcpClientConfig withSslConfigPeerHost(Object resolvedRemoteAddress, ReadOnlyTcpClientConfig config) {
        Objects.requireNonNull(resolvedRemoteAddress);
        Objects.requireNonNull(config);
        ClientSslConfig sslConfig = config.sslConfig();
        if (sslConfig != null && resolvedRemoteAddress instanceof InetSocketAddress) {
            String newSniHostname;
            String hostnameVerificationAlgorithm;
            String newPeerHost;
            InetSocketAddress socketAddress = (InetSocketAddress)resolvedRemoteAddress;
            InetAddress inetAddress = socketAddress.getAddress();
            String sniHostname = sslConfig.sniHostname();
            String peerHost = sslConfig.peerHost();
            if (sniHostname == null) {
                if (peerHost == null) {
                    newPeerHost = inetAddress.getHostAddress();
                    hostnameVerificationAlgorithm = null;
                    newSniHostname = null;
                } else {
                    newPeerHost = peerHost + '-' + inetAddress.getHostAddress();
                    if (StreamingConnectionFactory.isValidSniHostname(peerHost)) {
                        newSniHostname = peerHost;
                        hostnameVerificationAlgorithm = sslConfig.hostnameVerificationAlgorithm();
                    } else {
                        hostnameVerificationAlgorithm = null;
                        newSniHostname = null;
                    }
                }
            } else {
                newPeerHost = sniHostname + '-' + inetAddress.getHostAddress();
                newSniHostname = sniHostname;
                hostnameVerificationAlgorithm = sslConfig.hostnameVerificationAlgorithm();
            }
            return config.withSslConfigPeerHost(newPeerHost, socketAddress.getPort(), newSniHostname, hostnameVerificationAlgorithm);
        }
        return config;
    }

    private static boolean isValidSniHostname(String peerHost) {
        try {
            new SNIHostName(peerHost);
            return true;
        }
        catch (Throwable cause) {
            return false;
        }
    }
}

