/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.Channel;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.api.internal.SubscribableCompletable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.transport.netty.internal.NettyFutureCompletable;
import io.servicetalk.transport.netty.internal.PrivilegedListenableAsyncCloseable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class NettyChannelListenableAsyncCloseable
implements PrivilegedListenableAsyncCloseable {
    private static final AtomicIntegerFieldUpdater<NettyChannelListenableAsyncCloseable> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(NettyChannelListenableAsyncCloseable.class, "state");
    private final Channel channel;
    private volatile int state;
    private final Completable onCloseNoOffload;
    private final Completable onClose;

    public NettyChannelListenableAsyncCloseable(final Channel channel, Executor offloadingExecutor) {
        this.channel = Objects.requireNonNull(channel);
        this.onCloseNoOffload = new SubscribableCompletable(){

            @Override
            protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
                try {
                    subscriber.onSubscribe(Cancellable.IGNORE_CANCEL);
                }
                catch (Throwable cause) {
                    SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, cause);
                    return;
                }
                NettyFutureCompletable.connectToSubscriber(subscriber, channel.closeFuture());
            }
        };
        this.onClose = this.onCloseNoOffload.publishOn(offloadingExecutor);
    }

    @Override
    public final Completable closeAsync() {
        return this.closeAsync(this.onClose());
    }

    @Override
    public final Completable closeAsyncGracefully() {
        return this.closeAsyncGracefully(this.onClose());
    }

    @Override
    public final Completable closeAsyncNoOffload() {
        return this.closeAsync(this.onCloseNoOffload());
    }

    @Override
    public final Completable closeAsyncGracefullyNoOffload() {
        return this.closeAsyncGracefully(this.onCloseNoOffload());
    }

    private Completable closeAsync(final Completable source) {
        return new SubscribableCompletable(){

            @Override
            protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
                SourceAdapters.toSource(source).subscribe(subscriber);
                if (stateUpdater.getAndSet(NettyChannelListenableAsyncCloseable.this, 2) != 2) {
                    NettyChannelListenableAsyncCloseable.this.channel.close();
                }
            }
        };
    }

    private Completable closeAsyncGracefully(final Completable source) {
        return new SubscribableCompletable(){

            @Override
            protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
                if (stateUpdater.compareAndSet(NettyChannelListenableAsyncCloseable.this, 0, 1)) {
                    try {
                        NettyChannelListenableAsyncCloseable.this.doCloseAsyncGracefully();
                    }
                    catch (Throwable t) {
                        SubscriberUtils.deliverErrorFromSource(subscriber, t);
                        return;
                    }
                }
                SourceAdapters.toSource(source).subscribe(subscriber);
            }
        };
    }

    @Override
    public final Completable onClose() {
        return this.onClose;
    }

    final Completable onCloseNoOffload() {
        return this.onCloseNoOffload;
    }

    protected final Channel channel() {
        return this.channel;
    }

    protected void doCloseAsyncGracefully() {
        this.channel.close();
    }
}

