/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.buffer.api;

import io.servicetalk.buffer.api.BufferInputStream;
import io.servicetalk.buffer.api.BufferOutputStream;
import io.servicetalk.buffer.api.ByteProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public interface Buffer {
    public int capacity();

    public Buffer capacity(int var1);

    public int maxCapacity();

    public int readerIndex();

    public Buffer readerIndex(int var1);

    public int writerIndex();

    public Buffer writerIndex(int var1);

    public int readableBytes();

    public int writableBytes();

    public int maxWritableBytes();

    public Buffer ensureWritable(int var1);

    public int ensureWritable(int var1, boolean var2);

    default public boolean tryEnsureWritable(int minWritableBytes, boolean force) {
        switch (this.ensureWritable(minWritableBytes, force)) {
            case 0: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public Buffer clear();

    public boolean getBoolean(int var1);

    public byte getByte(int var1);

    public short getUnsignedByte(int var1);

    public short getShort(int var1);

    public short getShortLE(int var1);

    public int getUnsignedShort(int var1);

    public int getUnsignedShortLE(int var1);

    public int getMedium(int var1);

    public int getMediumLE(int var1);

    public int getUnsignedMedium(int var1);

    public int getUnsignedMediumLE(int var1);

    public int getInt(int var1);

    public int getIntLE(int var1);

    public long getUnsignedInt(int var1);

    public long getUnsignedIntLE(int var1);

    public long getLong(int var1);

    public long getLongLE(int var1);

    public char getChar(int var1);

    public float getFloat(int var1);

    public double getDouble(int var1);

    public Buffer getBytes(int var1, Buffer var2);

    public Buffer getBytes(int var1, Buffer var2, int var3);

    public Buffer getBytes(int var1, Buffer var2, int var3, int var4);

    public Buffer getBytes(int var1, byte[] var2);

    public Buffer getBytes(int var1, byte[] var2, int var3, int var4);

    public Buffer getBytes(int var1, ByteBuffer var2);

    public Buffer setBoolean(int var1, boolean var2);

    public Buffer setByte(int var1, int var2);

    public Buffer setShort(int var1, int var2);

    public Buffer setShortLE(int var1, int var2);

    public Buffer setMedium(int var1, int var2);

    public Buffer setMediumLE(int var1, int var2);

    public Buffer setInt(int var1, int var2);

    public Buffer setIntLE(int var1, int var2);

    public Buffer setLong(int var1, long var2);

    public Buffer setLongLE(int var1, long var2);

    public Buffer setChar(int var1, int var2);

    public Buffer setFloat(int var1, float var2);

    public Buffer setDouble(int var1, double var2);

    public Buffer setBytes(int var1, Buffer var2);

    public Buffer setBytes(int var1, Buffer var2, int var3);

    public Buffer setBytes(int var1, Buffer var2, int var3, int var4);

    public Buffer setBytes(int var1, byte[] var2);

    public Buffer setBytes(int var1, byte[] var2, int var3, int var4);

    public Buffer setBytes(int var1, ByteBuffer var2);

    public int setBytes(int var1, InputStream var2, int var3) throws IOException;

    public int setBytesUntilEndStream(int var1, InputStream var2, int var3) throws IOException;

    public boolean readBoolean();

    public byte readByte();

    public short readUnsignedByte();

    public short readShort();

    public short readShortLE();

    public int readUnsignedShort();

    public int readUnsignedShortLE();

    public int readMedium();

    public int readMediumLE();

    public int readUnsignedMedium();

    public int readUnsignedMediumLE();

    public int readInt();

    public int readIntLE();

    public long readUnsignedInt();

    public long readUnsignedIntLE();

    public long readLong();

    public long readLongLE();

    public char readChar();

    public float readFloat();

    public double readDouble();

    public Buffer readSlice(int var1);

    public Buffer readBytes(int var1);

    public Buffer readBytes(Buffer var1);

    public Buffer readBytes(Buffer var1, int var2);

    public Buffer readBytes(Buffer var1, int var2, int var3);

    public Buffer readBytes(byte[] var1);

    public Buffer readBytes(byte[] var1, int var2, int var3);

    public Buffer readBytes(ByteBuffer var1);

    public Buffer skipBytes(int var1);

    public Buffer writeBoolean(boolean var1);

    public Buffer writeByte(int var1);

    public Buffer writeShort(int var1);

    public Buffer writeShortLE(int var1);

    public Buffer writeMedium(int var1);

    public Buffer writeMediumLE(int var1);

    public Buffer writeInt(int var1);

    public Buffer writeIntLE(int var1);

    public Buffer writeLong(long var1);

    public Buffer writeLongLE(long var1);

    public Buffer writeChar(int var1);

    public Buffer writeFloat(float var1);

    public Buffer writeDouble(double var1);

    public Buffer writeBytes(Buffer var1);

    public Buffer writeBytes(Buffer var1, int var2);

    public Buffer writeBytes(Buffer var1, int var2, int var3);

    public Buffer writeBytes(byte[] var1);

    public Buffer writeBytes(byte[] var1, int var2, int var3);

    public Buffer writeBytes(ByteBuffer var1);

    public int writeBytes(InputStream var1, int var2) throws IOException;

    public int writeBytesUntilEndStream(InputStream var1, int var2) throws IOException;

    public Buffer writeAscii(CharSequence var1);

    public Buffer writeUtf8(CharSequence var1);

    public Buffer writeUtf8(CharSequence var1, int var2);

    public int indexOf(int var1, int var2, byte var3);

    public int bytesBefore(byte var1);

    public int bytesBefore(int var1, byte var2);

    public int bytesBefore(int var1, int var2, byte var3);

    public Buffer copy();

    public Buffer copy(int var1, int var2);

    public Buffer slice();

    public Buffer slice(int var1, int var2);

    public Buffer duplicate();

    public int nioBufferCount();

    public ByteBuffer toNioBuffer();

    public ByteBuffer toNioBuffer(int var1, int var2);

    public ByteBuffer[] toNioBuffers();

    public ByteBuffer[] toNioBuffers(int var1, int var2);

    public boolean isReadOnly();

    public Buffer asReadOnly();

    public boolean isDirect();

    public boolean hasArray();

    public byte[] array();

    public int arrayOffset();

    public int forEachByte(ByteProcessor var1);

    public int forEachByte(int var1, int var2, ByteProcessor var3);

    public int forEachByteDesc(ByteProcessor var1);

    public int forEachByteDesc(int var1, int var2, ByteProcessor var3);

    public int hashCode();

    public boolean equals(Object var1);

    public String toString();

    public String toString(Charset var1);

    public String toString(int var1, int var2, Charset var3);

    public static OutputStream asOutputStream(Buffer buffer) {
        return new BufferOutputStream(buffer);
    }

    public static InputStream asInputStream(Buffer buffer) {
        return new BufferInputStream(buffer);
    }
}

