/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.client.api.partition;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public interface PartitionAttributes {
    @Nullable
    public <T> T get(Key<T> var1);

    default public <T> boolean contains(Key<T> key) {
        return this.get(key) != null;
    }

    public void forEach(BiConsumer<Key, Object> var1);

    public int size();

    public boolean isEmpty();

    public static final class Key<T>
    implements Comparable<Key> {
        private static final AtomicInteger nextIdCounter = new AtomicInteger();
        private final int id = nextIdCounter.getAndIncrement();
        private final String toString;

        private Key() {
            this.toString = String.valueOf(this.id);
        }

        private Key(String toString) {
            this.toString = Objects.requireNonNull(toString) + '-' + this.id;
        }

        public static <T> Key<T> newKey(String toString) {
            return new Key<T>(toString);
        }

        public static <T> Key<T> newKey() {
            return new Key<T>();
        }

        public String toString() {
            return this.toString;
        }

        public boolean equals(Object o) {
            return o instanceof Key && this.id == ((Key)o).id;
        }

        public int hashCode() {
            return this.id;
        }

        @Override
        public int compareTo(Key o) {
            return Integer.compare(this.id, o.id);
        }
    }
}

