/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.utils.internal.PlatformDependent;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class CompositeCancellable
implements Cancellable {
    private static final AtomicIntegerFieldUpdater<CompositeCancellable> cancelledUpdater = AtomicIntegerFieldUpdater.newUpdater(CompositeCancellable.class, "cancelled");
    private final Cancellable[] others;
    private volatile int cancelled;

    private CompositeCancellable(Cancellable ... others) {
        assert (others.length > 2);
        this.others = Objects.requireNonNull(others);
    }

    public void cancel() {
        if (cancelledUpdater.compareAndSet(this, 0, 1)) {
            Throwable t = null;
            for (Cancellable other : this.others) {
                try {
                    if (other == null) continue;
                    other.cancel();
                }
                catch (Throwable tt) {
                    if (t == null) {
                        t = tt;
                        continue;
                    }
                    t.addSuppressed(tt);
                }
            }
            if (t != null) {
                PlatformDependent.throwException(t);
            }
        }
    }

    static Cancellable create(Cancellable ... toCompose) {
        switch (toCompose.length) {
            case 0: {
                throw new IllegalArgumentException("At least one Cancellable required to compose.");
            }
            case 1: {
                return Objects.requireNonNull(toCompose[0]);
            }
            case 2: {
                Cancellable first = Objects.requireNonNull(toCompose[0]);
                Cancellable second = Objects.requireNonNull(toCompose[1]);
                return () -> {
                    try {
                        first.cancel();
                    }
                    finally {
                        second.cancel();
                    }
                };
            }
        }
        return new CompositeCancellable(toCompose);
    }
}

