/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextMapHolder;
import io.servicetalk.concurrent.api.AsyncContextMapThreadLocal;
import io.servicetalk.concurrent.api.DefaultAsyncContextProvider;
import java.util.Objects;
import java.util.concurrent.Callable;

final class ContextPreservingCallable<V>
implements Callable<V> {
    private final AsyncContextMap saved;
    private final Callable<V> delegate;

    ContextPreservingCallable(Callable<V> delegate) {
        this(delegate, DefaultAsyncContextProvider.INSTANCE.contextMap());
    }

    ContextPreservingCallable(Callable<V> delegate, AsyncContextMap current) {
        this.saved = Objects.requireNonNull(current);
        this.delegate = Objects.requireNonNull(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V call() throws Exception {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof AsyncContextMapHolder) {
            AsyncContextMapHolder asyncContextMapHolder = (AsyncContextMapHolder)((Object)currentThread);
            AsyncContextMap prev = asyncContextMapHolder.asyncContextMap();
            try {
                asyncContextMapHolder.asyncContextMap(this.saved);
                V v = this.delegate.call();
                return v;
            }
            finally {
                asyncContextMapHolder.asyncContextMap(prev);
            }
        }
        return this.slowPath();
    }

    private V slowPath() throws Exception {
        AsyncContextMap prev = AsyncContextMapThreadLocal.contextThreadLocal.get();
        try {
            AsyncContextMapThreadLocal.contextThreadLocal.set(this.saved);
            V v = this.delegate.call();
            return v;
        }
        finally {
            AsyncContextMapThreadLocal.contextThreadLocal.set(prev);
        }
    }
}

