/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextMapHolder;
import io.servicetalk.concurrent.api.AsyncContextMapThreadLocal;
import java.util.Objects;

final class ContextPreservingCancellable
implements Cancellable {
    private final AsyncContextMap saved;
    private final Cancellable delegate;

    private ContextPreservingCancellable(Cancellable delegate, AsyncContextMap current) {
        this.saved = Objects.requireNonNull(current);
        this.delegate = Objects.requireNonNull(delegate);
    }

    static Cancellable wrap(Cancellable delegate, AsyncContextMap current) {
        return delegate instanceof ContextPreservingCancellable && ((ContextPreservingCancellable)delegate).saved == current ? delegate : new ContextPreservingCancellable(delegate, current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof AsyncContextMapHolder) {
            AsyncContextMapHolder asyncContextMapHolder = (AsyncContextMapHolder)((Object)currentThread);
            AsyncContextMap prev = asyncContextMapHolder.asyncContextMap();
            try {
                asyncContextMapHolder.asyncContextMap(this.saved);
                this.delegate.cancel();
            }
            finally {
                asyncContextMapHolder.asyncContextMap(prev);
            }
        } else {
            this.slowPath();
        }
    }

    private void slowPath() {
        AsyncContextMap prev = AsyncContextMapThreadLocal.contextThreadLocal.get();
        try {
            AsyncContextMapThreadLocal.contextThreadLocal.set(this.saved);
            this.delegate.cancel();
        }
        finally {
            AsyncContextMapThreadLocal.contextThreadLocal.set(prev);
        }
    }

    public String toString() {
        return ContextPreservingCancellable.class.getSimpleName() + "(" + this.delegate + ')';
    }
}

