/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.ContextPreservingCancellable;
import java.util.Objects;
import javax.annotation.Nullable;

final class ContextPreservingCancellableSingleSubscriber<T>
implements SingleSource.Subscriber<T> {
    final AsyncContextMap saved;
    final SingleSource.Subscriber<T> subscriber;

    ContextPreservingCancellableSingleSubscriber(SingleSource.Subscriber<T> subscriber, AsyncContextMap current) {
        this.subscriber = Objects.requireNonNull(subscriber);
        this.saved = Objects.requireNonNull(current);
    }

    public void onSubscribe(Cancellable cancellable) {
        this.subscriber.onSubscribe(ContextPreservingCancellable.wrap(cancellable, this.saved));
    }

    public void onSuccess(@Nullable T result) {
        this.subscriber.onSuccess(result);
    }

    public void onError(Throwable t) {
        this.subscriber.onError(t);
    }

    public String toString() {
        return ContextPreservingCancellableSingleSubscriber.class.getSimpleName() + "(" + this.subscriber + ')';
    }
}

